import java.awt.BorderLayout;
import java.awt.GridLayout;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import java.awt.event.FocusListener;
import java.awt.event.FocusEvent;
import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.DocumentEvent;

public class TemperatureView extends JPanel implements TemperatureListener, ActionListener, DocumentListener {

private Temperature m_temp;
private JLabel m_celsius;
private JLabel m_farenheit;
private JTextField m_newTemp;
private JComboBox m_newUnits;

private String choices[] = { "Celsius", "Farenheit" };

TemperatureView( Temperature a_temp ) {
	m_temp = a_temp;
	if ( m_temp != null)
		m_temp.addListener(this);
	m_celsius = new JLabel( "" + m_temp.getTemperatureInCelsius() );
	m_farenheit = new JLabel( "" + m_temp.getTemperatureInFarenheit() );
	m_newTemp = new JTextField( 20 );
	m_newTemp.getDocument().addDocumentListener( this );
	m_newUnits = new JComboBox( choices );
	m_newUnits.addActionListener( this );

	setLayout( new BorderLayout() );
	JPanel main = new JPanel( new GridLayout(3,2) );

	main.add(m_newTemp);
	main.add(m_newUnits);
	
	JLabel clabel = new JLabel( "Degrees Celsius: " );
	JLabel flabel = new JLabel( "Degrees Farenheit: " );
	main.add(clabel);
	main.add(m_celsius);
	main.add(flabel);
	main.add(m_farenheit);
	add( main, BorderLayout.NORTH );
}

public void changedUpdate( DocumentEvent e ) { changeTemperature(); }
public void insertUpdate( DocumentEvent e ) { changeTemperature(); }
public void removeUpdate( DocumentEvent e ) { changeTemperature(); }

public void actionPerformed( ActionEvent e ) { changeTemperature(); }

public void changeTemperature() {
	double d = 0;
	try {
		d = (new Double( m_newTemp.getText() )).doubleValue();
	} catch (Exception e) { d = 0; }

	if ( m_newUnits.getSelectedIndex() == 0 )
		m_temp.setTemperatureInCelsius( d );
	else if ( m_newUnits.getSelectedIndex() == 1 )
		m_temp.setTemperatureInFarenheit( d );
}

public void temperatureChanged() {
	m_celsius.setText( "" + m_temp.getTemperatureInCelsius() );
	m_farenheit.setText( "" + m_temp.getTemperatureInFarenheit() );
	repaint();
}

}
