import java.util.Vector;

public class Temperature {

private double m_c;
private Vector m_temperatureListeners;

Temperature() { m_temperatureListeners = new Vector(); }

private void setC( double d ) { m_c = d; temperatureChanged(); }

private void temperatureChanged() {
	int i=0;
	TemperatureListener tl;
	for (i=0;i<m_temperatureListeners.size();i++)
	{
		tl = (TemperatureListener) m_temperatureListeners.elementAt(i);
		tl.temperatureChanged();
	}
}

public void addListener( TemperatureListener tl ) {
	if ( m_temperatureListeners.indexOf( tl ) == -1 )
	{
		m_temperatureListeners.add( tl );
	}
} 

public void removeListener( TemperatureListener tl ) {
	m_temperatureListeners.remove( tl );
}


public double getTemperatureInCelsius() { return m_c; }
public void setTemperatureInCelsius( double a_c ) { setC( a_c ); }

public double getTemperatureInKelvin() { return (m_c + 273); }
public void setTemperatureInKelvin( double a_k ) { setC( a_k - 273 ); }

public double getTemperatureInFarenheit() { return ((((double)9/(double)5)*m_c) + 32); }
public void setTemperatureInFarenheit( double a_f ) { setC( ((a_f-32)*((double)5/(double)9)) ); }

/*
public void showAllValues() {
	System.out.println( "=====================================");
	System.out.println( "Celsius..... "+ getTemperatureInCelsius() );
	System.out.println( "Kelvin...... "+ getTemperatureInKelvin() );
	System.out.println( "Farenheit... "+ getTemperatureInFarenheit() );
}

public static void main( String args[] ) {
	Temperature l = new Temperature();
	double f = 42.39;
	l.setTemperatureInCelsius( f );
	l.showAllValues();
	l.setTemperatureInKelvin( f );
	l.showAllValues();
	l.setTemperatureInFarenheit( f );
	l.showAllValues();
}
*/
}
