import java.awt.BorderLayout;
import java.awt.GridLayout;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import java.awt.event.FocusListener;
import java.awt.event.FocusEvent;
import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.DocumentEvent;

public class MassView extends JPanel implements MassListener, ActionListener, DocumentListener {

private Mass m_mass;
private JLabel m_kilograms;
private JLabel m_pounds;
private JTextField m_newTemp;
private JComboBox m_newUnits;

private String choices[] = { "Kilograms", "Pounds" };

MassView( Mass a_mass ) {
	m_mass = a_mass;
	if ( m_mass != null)
		m_mass.addListener(this);
	m_kilograms = new JLabel( "" + m_mass.getMassInKilograms() );
	m_pounds = new JLabel( "" + m_mass.getMassInPounds() );
	m_newTemp = new JTextField( 20 );
	m_newTemp.getDocument().addDocumentListener( this );
	m_newUnits = new JComboBox( choices );
	m_newUnits.addActionListener( this );

	setLayout( new BorderLayout() );
	JPanel main = new JPanel( new GridLayout(3,2) );

	main.add(m_newTemp);
	main.add(m_newUnits);
	
	JLabel clabel = new JLabel( "Kilograms: " );
	JLabel flabel = new JLabel( "Pounds: " );
	main.add(clabel);
	main.add(m_kilograms);
	main.add(flabel);
	main.add(m_pounds);
	add( main, BorderLayout.NORTH );
}

public void changedUpdate( DocumentEvent e ) { changeMass(); }
public void insertUpdate( DocumentEvent e ) { changeMass(); }
public void removeUpdate( DocumentEvent e ) { changeMass(); }

public void actionPerformed( ActionEvent e ) { changeMass(); }

public void changeMass() {
	double d = 0;
	try {
		d = (new Double( m_newTemp.getText() )).doubleValue();
	} catch (Exception e) { d = 0; }

	if ( m_newUnits.getSelectedIndex() == 0 )
		m_mass.setMassInKilograms( d );
	else if ( m_newUnits.getSelectedIndex() == 1 )
		m_mass.setMassInPounds( d );
}

public void massChanged() {
	m_kilograms.setText( "" + m_mass.getMassInKilograms() );
	m_pounds.setText( "" + m_mass.getMassInPounds() );
	repaint();
}

}
