import java.util.Vector;

public class Mass {

private double m_g;
private Vector m_massListeners;

Mass() { m_massListeners = new Vector(); }

private void setG( double d ) { m_g = d; massChanged(); }

private void massChanged() {
	int i=0;
	MassListener ml;
	for (i=0;i<m_massListeners.size();i++)
	{
		ml = (MassListener) m_massListeners.elementAt(i);
		ml.massChanged();
	}
}

public void addListener( MassListener ml ) {
	if ( m_massListeners.indexOf( ml ) == -1 )
	{
		m_massListeners.add( ml );
	}
} 

public void removeListener( MassListener ml ) {
	m_massListeners.remove( ml );
}

// 2.2046226 kg/lb
public double getMassInGrams() { return m_g; }
public void setMassInGrams( double a_g ) { setG( a_g ); }

public double getMassInMilligrams() { return (m_g * 1000); }
public void setMassInMilligrams( double a_mg ) { setG( a_mg / 1000 ); }

public double getMassInKilograms() { return (m_g / 1000); }
public void setMassInKilograms( double a_kg ) { setG( a_kg * 1000 ); }

public double getMassInPounds() { return (getMassInKilograms() * 2.2046266); }
public void setMassInPounds( double a_lb ) { setMassInKilograms( a_lb / 2.2046266); }

public double getMassInOunces() { return (getMassInPounds() * 16); }
public void setMassInOunces( double a_oz ) { setMassInPounds( a_oz / 16 ); }



public void showAllValues() {
	System.out.println( "=====================================");
	System.out.println( "Milligrams... "+ getMassInMilligrams() );
	System.out.println( "Grams........ "+ getMassInGrams() );
	System.out.println( "Kilograms.... "+ getMassInKilograms() );
	System.out.println( "Pounds....... "+ getMassInPounds() );
	System.out.println( "Ounces....... "+ getMassInOunces() );
}

public static void main( String args[] ) {
	Mass l = new Mass();
	double f = 42.39;
	l.setMassInMilligrams( f );
	l.showAllValues();
	l.setMassInGrams( f );
	l.showAllValues();
	l.setMassInKilograms( f );
	l.showAllValues();
	l.setMassInPounds( f );
	l.showAllValues();
	l.setMassInOunces( f );
}
}
