import java.awt.BorderLayout;
import java.awt.GridLayout;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import java.awt.event.FocusListener;
import java.awt.event.FocusEvent;
import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.DocumentEvent;

public class LengthView extends JPanel implements LengthListener, ActionListener, DocumentListener {

private Length m_len;
private JLabel m_kilometers;
private JLabel m_miles;
private JLabel m_meters;
private JLabel m_centimeters;
private JLabel m_feet;
private JLabel m_inches;
private JTextField m_newTemp;
private JComboBox m_newUnits;

private String choices[] = { "Kilometers", "Miles", "Meters", "Centimeters", "Feet", "Inches" };

LengthView( Length a_len ) {
	m_len = a_len;
	if ( m_len != null)
		m_len.addListener(this);
	m_kilometers = new JLabel( "" + m_len.getLengthInKilometers() );
	m_miles = new JLabel( "" + m_len.getLengthInMiles() );
	m_meters = new JLabel( "" + m_len.getLengthInMeters() );
	m_centimeters = new JLabel( "" + m_len.getLengthInCentimeters() );
	m_feet = new JLabel( "" + m_len.getLengthInFeet() );
	m_inches = new JLabel( "" + m_len.getLengthInInches() );
	m_newTemp = new JTextField( 20 );
	m_newTemp.getDocument().addDocumentListener( this );
	m_newUnits = new JComboBox( choices );
	m_newUnits.addActionListener( this );

	setLayout( new BorderLayout() );
	JPanel main = new JPanel( new GridLayout(7,2) );

	main.add(m_newTemp);
	main.add(m_newUnits);
	
	JLabel kmlabel = new JLabel( "Kilometers: " );
	JLabel milabel = new JLabel( "Miles: " );
	JLabel mlabel = new JLabel( "Meters: " );
	JLabel cmlabel = new JLabel( "Centimeters: " );
	JLabel ftlabel = new JLabel( "Feet: " );
	JLabel inlabel = new JLabel( "Inches: " );
	main.add(kmlabel);
	main.add(m_kilometers);
	main.add(milabel);
	main.add(m_miles);
	main.add(mlabel);
	main.add(m_meters);
	main.add(cmlabel);
	main.add(m_centimeters);
	main.add(ftlabel);
	main.add(m_feet);
	main.add(inlabel);
	main.add(m_inches);
	add( main, BorderLayout.NORTH );
}

public void changedUpdate( DocumentEvent e ) { changeLength(); }
public void insertUpdate( DocumentEvent e ) { changeLength(); }
public void removeUpdate( DocumentEvent e ) { changeLength(); }

public void actionPerformed( ActionEvent e ) { changeLength(); }

public void changeLength() {
	double d = 0;
	try {
		d = (new Double( m_newTemp.getText() )).doubleValue();
	} catch (Exception e) { d = 0; }

	if ( m_newUnits.getSelectedIndex() == 0 )
		m_len.setLengthInKilometers( d );
	else if ( m_newUnits.getSelectedIndex() == 1 )
		m_len.setLengthInMiles( d );
	else if ( m_newUnits.getSelectedIndex() == 2 )
		m_len.setLengthInMeters( d );
	else if ( m_newUnits.getSelectedIndex() == 3 )
		m_len.setLengthInCentimeters( d );
	else if ( m_newUnits.getSelectedIndex() == 4 )
		m_len.setLengthInFeet( d );
	else if ( m_newUnits.getSelectedIndex() == 5 )
		m_len.setLengthInInches( d );
}

public void lengthChanged() {
	m_kilometers.setText( "" + m_len.getLengthInKilometers() );
	m_miles.setText( "" + m_len.getLengthInMiles() );
	m_meters.setText( "" + m_len.getLengthInMeters() );
	m_centimeters.setText( "" + m_len.getLengthInCentimeters() );
	m_feet.setText( "" + m_len.getLengthInFeet() );
	m_inches.setText( "" + m_len.getLengthInInches() );
	repaint();
}

}
