import java.util.Vector;

public class Length {

private double m_cm;
private Vector m_lengthListeners;

Length() { m_lengthListeners = new Vector(); }

private void setCm( double d ) { m_cm = d; lengthChanged(); }

private void lengthChanged() {
	int i=0;
	LengthListener ll;
	for (i=0;i<m_lengthListeners.size();i++)
	{
		ll = (LengthListener) m_lengthListeners.elementAt(i);
		ll.lengthChanged();
	}
}

public void addListener( LengthListener ll ) {
	if ( m_lengthListeners.indexOf( ll ) == -1 )
	{
		m_lengthListeners.add( ll );
	}
} 

public void removeListener( LengthListener ll ) {
	m_lengthListeners.remove( ll );
}

public double getLengthInMillimeters() { return (m_cm * 10); }
public void setLengthInMillimeters( double a_mm ) { setCm( a_mm / 10 ); }

public double getLengthInCentimeters() { return m_cm; }
public void setLengthInCentimeters( double a_cm ) { setCm( a_cm ); }

public double getLengthInInches() { return (m_cm / 2.54); }
public void setLengthInInches( double a_inches ) { setCm( a_inches * 2.54 ); }

public double getLengthInMeters() { return (m_cm / 100); }
public void setLengthInMeters( double a_meters ) { setCm( a_meters * 100 ); }

public double getLengthInFeet() { return (getLengthInInches()/12); }
public void setLengthInFeet( double a_feet ) { setLengthInInches(a_feet * 12); }

public double getLengthInYards() { return (getLengthInFeet()/3); }
public void setLengthInYards( double a_yds ) { setLengthInFeet(a_yds * 3); }

public double getLengthInKilometers() { return (m_cm / 100000); }
public void setLengthInKilometers( double a_km ) { setCm( a_km * 100000 ); }

public double getLengthInMiles() { return (getLengthInFeet()/5280); }
public void setLengthInMiles( double a_miles ) { setLengthInFeet( a_miles*5280 ); }

/*
public void showAllValues() {
	System.out.println( "=====================================");
	System.out.println( "Millimeters... "+ getLengthInMillimeters() );
	System.out.println( "Centimeters... "+ getLengthInCentimeters() );
	System.out.println( "Meters........ "+ getLengthInMeters() );
	System.out.println( "Kilometers.... "+ getLengthInKilometers() );
	System.out.println( "Inches........ "+ getLengthInInches() );
	System.out.println( "Feet.......... "+ getLengthInFeet() );
	System.out.println( "Yards......... "+ getLengthInYards() );
	System.out.println( "Miles......... "+ getLengthInMiles() );
}

public static void main( String args[] ) {
	Length l = new Length();
	double f = 42.39;
	l.setLengthInMillimeters( f );
	l.showAllValues();
	l.setLengthInCentimeters( f );
	l.showAllValues();
	l.setLengthInMeters( f );
	l.showAllValues();
	l.setLengthInKilometers( f );
	l.showAllValues();
	l.setLengthInInches( f );
	l.showAllValues();
	l.setLengthInFeet( f );
	l.showAllValues();
	l.setLengthInYards( f );
	l.showAllValues();
	l.setLengthInMiles( f );
	l.showAllValues();
}
*/
}
