/*
 * Decompiled with CFR 0.152.
 */
package com.t4d.budget;

import com.t4d.budget.BudgetModel;
import com.t4d.budget.GraphViewerColorRenderer;
import com.t4d.budget.GraphViewerControlPanel;
import com.t4d.budget.GraphViewerModel;
import com.t4d.budget.GraphViewerView;
import com.t4d.budget.JDateField;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class ViewGraphFrame
extends JFrame
implements ActionListener {
    private BudgetModel m_budget;
    private JDateField m_start;
    private JDateField m_end;
    private GraphViewerModel m_gvm;
    private GraphViewerView m_gvv;
    private JComboBox m_bgcolor;

    public ViewGraphFrame(BudgetModel bm) {
        super("Graph view");
        this.m_budget = bm;
        this.m_gvm = null;
        JLabel startDate = new JLabel("Starting date: ");
        JLabel endDate = new JLabel("End date: ");
        this.m_start = new JDateField(new Date());
        this.m_start.setID("Start");
        this.m_start.addActionListener(this);
        this.m_end = new JDateField(new Date());
        this.m_end.setID("End");
        this.m_end.addActionListener(this);
        JButton okay = new JButton("Okay");
        okay.addActionListener(this);
        JButton cancel = new JButton("Cancel");
        cancel.addActionListener(this);
        JPanel pane = new JPanel(new BorderLayout());
        JPanel center = new JPanel();
        JPanel south = new JPanel();
        center.add(startDate);
        center.add(this.m_start);
        center.add(endDate);
        center.add(this.m_end);
        south.add(okay);
        south.add(cancel);
        pane.add((Component)center, "Center");
        pane.add((Component)south, "South");
        pane.revalidate();
        ((Component)this).setSize(350, 150);
        this.getContentPane().add(pane);
        ((Component)this).setVisible(true);
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("Okay")) {
            if (this.m_start.getDate().before(this.m_end.getDate())) {
                ((Component)this).setVisible(false);
                ((Component)this).setSize(800, 600);
                this.m_gvm = new GraphViewerModel(this.m_budget, this.m_start.getDate(), this.m_end.getDate());
                this.m_gvv = new GraphViewerView(this.m_gvm);
                JPanel gvp = new JPanel(new BorderLayout());
                gvp.add((Component)this.m_gvv, "Center");
                JLabel lstart = new JLabel("Start date:");
                this.m_start.setID("Start");
                this.m_start.addActionListener(this);
                JLabel lend = new JLabel("End date:");
                this.m_end.setID("End");
                this.m_end.addActionListener(this);
                JLabel lbgcolor = new JLabel("Background color: ");
                String[] colors = new String[]{"Black", "Dark Gray", "Gray", "Light Gray", "White"};
                this.m_bgcolor = new JComboBox<String>(colors);
                this.m_bgcolor.setSelectedItem("Dark Gray");
                this.m_bgcolor.setRenderer(new GraphViewerColorRenderer());
                this.m_bgcolor.addActionListener(this);
                JPanel south = new JPanel();
                south.add(lstart);
                south.add(this.m_start);
                south.add(lend);
                south.add(this.m_end);
                south.add(lbgcolor);
                south.add(this.m_bgcolor);
                gvp.add((Component)south, "South");
                GraphViewerControlPanel gvcp = new GraphViewerControlPanel(this.m_gvm, this.m_gvv);
                gvp.add((Component)gvcp, "East");
                this.getContentPane().removeAll();
                this.getContentPane().add(gvp);
                ((Component)this).setVisible(true);
            } else {
                JOptionPane.showMessageDialog(this, "Start date must be before end date", "Error!", 0);
            }
        } else if (e.getActionCommand().equals("Cancel")) {
            this.dispose();
        } else if (e.getActionCommand().equals("Start")) {
            if (this.m_gvm != null) {
                this.m_gvm.setStartDate(this.m_start.getDate());
                this.m_start.setDate(this.m_gvm.getStartDate());
                this.m_end.setDate(this.m_gvm.getEndDate());
            }
        } else if (e.getActionCommand().equals("End") && this.m_gvm != null) {
            this.m_gvm.setEndDate(this.m_end.getDate());
            this.m_start.setDate(this.m_gvm.getStartDate());
            this.m_end.setDate(this.m_gvm.getEndDate());
        }
        if (e.getSource().equals(this.m_bgcolor)) {
            String clr = (String)((JComboBox)e.getSource()).getSelectedItem();
            Color color = null;
            if (clr.equals("Black")) {
                color = Color.black;
            } else if (clr.equals("Dark Gray")) {
                color = Color.darkGray;
            } else if (clr.equals("Gray")) {
                color = Color.gray;
            } else if (clr.equals("Light Gray")) {
                color = Color.lightGray;
            } else if (clr.equals("White")) {
                color = Color.white;
            }
            if (color != null && this.m_gvv != null) {
                this.m_gvv.setBackgroundColor(color);
            }
        }
    }
}

