/*
 * Decompiled with CFR 0.152.
 */
package com.t4d.budget;

import com.t4d.budget.AccountInfoListener;
import com.t4d.budget.AccountListListener;
import com.t4d.budget.AccountModel;
import com.t4d.budget.AccountTransactionListListener;
import com.t4d.budget.BudgetListener;
import com.t4d.budget.InvalidDateException;
import com.t4d.budget.InvalidTransactionException;
import com.t4d.budget.JCurrencyField;
import com.t4d.budget.JDateField;
import com.t4d.budget.TransactionListener;
import com.t4d.budget.TransactionModel;
import com.t4d.budget.TransactionNotFoundException;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class TransactionView
extends JPanel
implements TransactionListener,
AccountTransactionListListener,
AccountListListener,
BudgetListener,
AccountInfoListener,
ActionListener,
FocusListener {
    private TransactionModel m_model = null;
    private JDateField m_dateField = new JDateField();
    private JTextField m_descField = new JTextField();
    private JCurrencyField m_debField = new JCurrencyField();
    private JCurrencyField m_credField = new JCurrencyField();
    private JCurrencyField m_runningTotalField = new JCurrencyField();
    private JButton m_removeBut;
    private JComboBox m_transferBox = new JComboBox();
    private String m_lastDesc;
    private String m_lastXfer;
    private int m_dialogsOpen = 0;
    private boolean m_ignoreXferEvents = true;

    public TransactionView() {
        this.m_removeBut = new JButton("Delete");
        this.m_dateField.addActionListener(this);
        this.m_dateField.setID("Date");
        this.m_descField.addActionListener(this);
        this.m_descField.addFocusListener(this);
        this.m_debField.addActionListener(this);
        this.m_debField.setID("Debits");
        this.m_credField.addActionListener(this);
        this.m_credField.setID("Credits");
        this.m_transferBox.addActionListener(this);
        this.m_removeBut.addActionListener(this);
        this.m_dateField.setHorizontalAlignment(0);
        this.m_descField.setHorizontalAlignment(2);
        this.m_debField.setHorizontalAlignment(4);
        this.m_credField.setHorizontalAlignment(4);
        this.m_runningTotalField.setHorizontalAlignment(4);
        this.m_runningTotalField.setEditable(false);
        this.m_transferBox.setFont(new Font("Arial New", 0, 10));
        this.m_removeBut.setFont(new Font("Arial New", 0, 10));
        this.add(this.m_dateField);
        this.add(this.m_descField);
        this.add(this.m_debField);
        this.add(this.m_credField);
        this.add(this.m_runningTotalField);
        this.add(this.m_transferBox);
        this.add(this.m_removeBut);
        this.m_lastDesc = "";
        this.m_lastXfer = "External";
        this.m_ignoreXferEvents = false;
    }

    public TransactionView(TransactionModel tm) {
        this();
        this.setModel(tm);
    }

    public void setModel(TransactionModel tm) {
        if (this.m_model != null) {
            this.m_model.removeTransactionListener(this);
            if (this.m_model.getAccount() != null) {
                this.m_model.getAccount().removeTransactionListener(this);
                if (this.m_model.getAccount().getBudget() != null) {
                    this.m_model.getAccount().getBudget().removeAccountListListener(this);
                    this.m_model.getAccount().getBudget().removeBudgetListener(this);
                }
            }
        }
        this.m_model = tm;
        if (this.m_model != null) {
            this.m_model.addTransactionListener(this);
            if (this.m_model.getAccount() != null) {
                this.m_model.getAccount().addTransactionListener(this);
                if (this.m_model.getAccount().getBudget() != null) {
                    this.m_model.getAccount().getBudget().addAccountListListener(this);
                    this.m_model.getAccount().getBudget().addBudgetListener(this);
                }
            }
            if (this.m_model.getCompanion() != null && this.m_model.getCompanion().getAccount() != null) {
                this.m_lastXfer = this.m_model.getCompanion().getAccount().getName();
            }
        } else {
            this.transferFocus();
        }
        this.refreshTransferBox();
    }

    public void transactionInfoChanged() {
        this.redraw();
    }

    public void accountTransactionListChanged() {
        this.redraw();
    }

    public void accountInfoChanged() {
        this.redraw();
    }

    public void accountListChanged() {
        this.refreshTransferBox();
    }

    public void budgetChanged() {
        this.refreshTransferBox();
    }

    private void refreshTransferBox() {
        int i;
        int size;
        this.m_ignoreXferEvents = true;
        this.m_transferBox.removeAllItems();
        this.m_transferBox.addItem("External");
        if (this.m_model != null && this.m_model.getAccount() != null && this.m_model.getAccount().getBudget() != null && this.m_model.getAccount().getBudget().getAccounts() != null) {
            size = this.m_model.getAccount().getBudget().getAccounts().size();
            i = 0;
            while (i < size) {
                AccountModel am = (AccountModel)this.m_model.getAccount().getBudget().getAccounts().get(i);
                if (!am.equals(this.m_model.getAccount().getBudget().getCurrentAccount())) {
                    this.m_transferBox.addItem(am.getName());
                }
                ++i;
            }
        }
        this.m_ignoreXferEvents = false;
        size = this.m_transferBox.getItemCount();
        i = 0;
        while (i < size) {
            if (((String)this.m_transferBox.getItemAt(i)).equals(this.m_lastXfer)) {
                this.m_transferBox.setSelectedIndex(i);
                this.m_transferBox.repaint();
                i = size;
            }
            ++i;
        }
        this.m_transferBox.repaint();
        this.redraw();
    }

    private void redraw() {
        int i;
        if (this.m_model == null) {
            this.m_ignoreXferEvents = true;
            this.m_transferBox.removeAllItems();
            this.m_transferBox.addItem("External");
            this.m_ignoreXferEvents = false;
            return;
        }
        this.m_dateField.setDate(this.m_model.getDate());
        this.m_dateField.setColumns(7);
        this.m_descField.setText(this.m_model.getDescription());
        this.m_descField.setColumns(30);
        if (this.m_model.getAmount() < 0) {
            this.m_debField.setIntValue(-this.m_model.getAmount());
            this.m_credField.setIntValue(0);
        } else {
            this.m_debField.setIntValue(0);
            this.m_credField.setIntValue(this.m_model.getAmount());
        }
        this.m_debField.setColumns(10);
        this.m_credField.setColumns(10);
        if (this.m_model.getAccount() == null) {
            this.m_ignoreXferEvents = true;
            this.m_transferBox.removeAllItems();
            this.m_transferBox.addItem("External");
            this.m_ignoreXferEvents = false;
            return;
        }
        int total = this.m_model.getAccount().getStart();
        int size = this.m_model.getAccount().getTransactionList().indexOf(this.m_model);
        if (size != -1) {
            i = 0;
            while (i <= size) {
                TransactionModel tm = (TransactionModel)this.m_model.getAccount().getTransactionList().get(i);
                total += tm.getAmount();
                ++i;
            }
        }
        this.m_runningTotalField.setIntValue(total);
        this.m_runningTotalField.setColumns(10);
        if (this.m_model.getAccount().getBudget() == null) {
            this.m_ignoreXferEvents = true;
            this.m_transferBox.removeAllItems();
            this.m_transferBox.addItem("External");
            this.m_ignoreXferEvents = false;
            return;
        }
        size = this.m_transferBox.getItemCount();
        i = 0;
        while (i < size) {
            if (((String)this.m_transferBox.getItemAt(i)).equals(this.m_lastXfer)) {
                this.m_transferBox.setSelectedIndex(i);
                i = size;
            }
            this.m_transferBox.repaint();
            ++i;
        }
        this.m_lastDesc = this.m_descField.getText();
        this.repaint();
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("Delete")) {
            if (this.m_model != null && this.m_model.getAccount() != null) {
                try {
                    if (this.m_model.getCompanion() != null && this.m_model.getCompanion().getAccount() != null) {
                        this.m_model.getCompanion().getAccount().removeTransaction(this.m_model.getCompanion());
                    }
                    this.m_model.getAccount().removeTransaction(this.m_model);
                    this.setModel(null);
                }
                catch (TransactionNotFoundException tnfe) {}
            }
        } else if (e.getActionCommand().equals("Debits")) {
            if (this.m_model != null) {
                this.m_model.setAmount(-((JCurrencyField)e.getSource()).getIntValue());
            }
        } else if (e.getActionCommand().equals("Credits")) {
            if (this.m_model != null) {
                this.m_model.setAmount(((JCurrencyField)e.getSource()).getIntValue());
            }
        } else if (e.getActionCommand().equals("Date")) {
            if (this.m_model != null) {
                try {
                    this.m_model.setDate(((JDateField)e.getSource()).getDate());
                }
                catch (InvalidDateException ide) {
                    System.out.println(ide);
                    if (this.m_dialogsOpen < 1) {
                        ++this.m_dialogsOpen;
                        JOptionPane.showMessageDialog(this, "Transactions cannot take place in the future.  Use the Budget tab to modify future predictions.", "Error!", 0);
                        --this.m_dialogsOpen;
                    }
                    this.redraw();
                }
            }
        } else if (e.getSource().equals(this.m_transferBox)) {
            if (!this.m_ignoreXferEvents) {
                this.updateFromUI();
            }
        } else {
            this.updateFromUI();
        }
    }

    public void focusGained(FocusEvent e) {
    }

    public void focusLost(FocusEvent e) {
        this.updateFromUI();
    }

    private void updateFromUI() {
        String dateStr = this.m_dateField.getText();
        String debStr = this.m_debField.getText();
        String credStr = this.m_credField.getText();
        String xferStr = (String)this.m_transferBox.getSelectedItem();
        if (!this.m_lastDesc.equals(this.m_descField.getText()) && this.m_model != null) {
            this.m_model.setDescription(this.m_descField.getText());
        }
        if (xferStr != null && !xferStr.equals(this.m_lastXfer)) {
            this.m_lastXfer = xferStr;
            int size = this.m_transferBox.getItemCount();
            int i = 0;
            while (i < size) {
                if (((String)this.m_transferBox.getItemAt(i)).equals(this.m_lastXfer)) {
                    this.m_transferBox.setSelectedIndex(i);
                }
                ++i;
            }
            this.m_transferBox.repaint();
            if (xferStr.equals("External")) {
                if (this.m_model != null && this.m_model.getCompanion() != null && this.m_model.getCompanion().getAccount() != null) {
                    try {
                        this.m_model.getCompanion().getAccount().removeTransaction(this.m_model.getCompanion());
                    }
                    catch (TransactionNotFoundException transactionNotFoundException) {
                        // empty catch block
                    }
                    this.m_model.setCompanion(null);
                }
            } else {
                if (this.m_model != null && this.m_model.getCompanion() != null && this.m_model.getCompanion().getAccount() != null) {
                    try {
                        this.m_model.getCompanion().getAccount().removeTransaction(this.m_model.getCompanion());
                    }
                    catch (TransactionNotFoundException transactionNotFoundException) {
                        // empty catch block
                    }
                    this.m_model.setCompanion(null);
                }
                if (this.m_model != null) {
                    TransactionModel comp = new TransactionModel();
                    comp.setDescription(this.m_model.getDescription());
                    comp.setAmount(-this.m_model.getAmount());
                    try {
                        comp.setDate(this.m_model.getDate());
                    }
                    catch (InvalidDateException invalidDateException) {
                        // empty catch block
                    }
                    if (this.m_model.getAccount() != null && this.m_model.getAccount().getBudget() != null) {
                        size = this.m_model.getAccount().getBudget().getAccounts().size();
                        i = 0;
                        while (i < size) {
                            AccountModel am = (AccountModel)this.m_model.getAccount().getBudget().getAccounts().get(i);
                            if (am.getName().equals(xferStr)) {
                                try {
                                    am.addTransaction(comp);
                                    if (this.m_model != null) {
                                        this.m_model.setCompanion(comp);
                                    }
                                    i = size;
                                }
                                catch (InvalidTransactionException invalidTransactionException) {
                                    // empty catch block
                                }
                            }
                            ++i;
                        }
                    }
                }
            }
        }
    }
}

