/*
 * Decompiled with CFR 0.152.
 */
package com.t4d.budget;

import com.t4d.budget.AccountModel;
import com.t4d.budget.InvalidDateException;
import com.t4d.budget.InvalidTransactionException;
import com.t4d.budget.TransactionListener;
import com.t4d.budget.TransactionNotFoundException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Date;
import java.util.Vector;

public class TransactionModel
implements Serializable {
    private AccountModel m_account;
    private Date m_date;
    private String m_description;
    private int m_depositAmount;
    private TransactionModel m_companion;
    private Vector m_listeners = new Vector();

    public TransactionModel() {
        this.m_date = null;
        this.m_description = null;
        this.m_depositAmount = 0;
        this.m_companion = null;
        this.m_account = null;
    }

    public TransactionModel(Date date, String desc, int amt) {
        try {
            this.setDate(date);
        }
        catch (InvalidDateException ide) {
            this.m_date = new Date();
        }
        this.m_description = desc;
        this.m_depositAmount = amt;
        this.m_companion = null;
        this.m_account = null;
    }

    public TransactionModel(Date date, String desc, int amt, AccountModel account) {
        try {
            this.setDate(date);
        }
        catch (InvalidDateException ide) {
            this.m_date = new Date();
        }
        this.m_description = desc;
        this.m_depositAmount = amt;
        this.m_account = account;
    }

    public boolean isInitialized() {
        return this.m_date != null && this.m_description != null;
    }

    public String getDescription() {
        return this.m_description;
    }

    public void setDescription(String desc) {
        this.m_description = desc;
        if (this.m_companion != null && !this.m_companion.getDescription().equals(desc)) {
            this.m_companion.setDescription(desc);
        }
        this.transactionInfoChanged();
    }

    public Date getDate() {
        return this.m_date;
    }

    public void setDate(Date d) throws InvalidDateException {
        Date now = new Date();
        if (d == null) {
            InvalidDateException ide = new InvalidDateException("null date is invalid");
            throw ide;
        }
        if (this.m_account != null) {
            AccountModel account = this.m_account;
            Date oldDate = this.getDate();
            try {
                account.removeTransaction(this);
                this.m_date = d;
                account.addTransaction(this);
                if (this.m_companion != null && this.m_companion.getDate() != d) {
                    this.m_companion.setDate(d);
                }
                this.transactionInfoChanged();
            }
            catch (InvalidTransactionException ite) {
                System.out.println("There is no reason we should ever get here");
            }
            catch (TransactionNotFoundException tnfe) {
                this.m_date = d;
                if (this.m_companion != null && this.m_companion.getDate() != d) {
                    this.m_companion.setDate(d);
                }
                this.transactionInfoChanged();
            }
        } else {
            this.m_date = d;
            if (this.m_companion != null && this.m_companion.getDate() != d) {
                this.m_companion.setDate(d);
            }
            this.transactionInfoChanged();
        }
    }

    public int getAmount() {
        return this.m_depositAmount;
    }

    public void setAmount(int amt) {
        this.m_depositAmount = amt;
        this.transactionInfoChanged();
        if (this.m_companion != null && this.m_companion.getAmount() != -amt) {
            this.m_companion.setAmount(-amt);
        }
        if (this.m_account != null) {
            this.m_account.setStart(this.m_account.getStart());
        }
    }

    public void addTransactionListener(TransactionListener tl) {
        int ind = this.m_listeners.indexOf(tl);
        if (ind == -1) {
            this.m_listeners.add(tl);
        }
    }

    public void removeTransactionListener(TransactionListener tl) {
        int ind = this.m_listeners.indexOf(tl);
        if (ind != -1) {
            this.m_listeners.removeElementAt(ind);
        }
    }

    private void transactionInfoChanged() {
        int size = this.m_listeners.size();
        int i = 0;
        while (i < size) {
            TransactionListener tl = (TransactionListener)this.m_listeners.get(i);
            tl.transactionInfoChanged();
            ++i;
        }
        if (this.m_account != null && this.m_account.getBudget() != null) {
            this.m_account.getBudget().setNeedsSave(true);
        }
    }

    public void setAccount(AccountModel am) {
        if (am != null && !am.isInitialized()) {
            return;
        }
        this.m_account = am;
    }

    public AccountModel getAccount() {
        return this.m_account;
    }

    public void setCompanion(TransactionModel tm) {
        this.m_companion = tm;
        if (!(this.m_companion == null || this.m_companion.getCompanion() != null && this.m_companion.getCompanion().equals(this))) {
            this.m_companion.setCompanion(this);
        }
    }

    public TransactionModel getCompanion() {
        return this.m_companion;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        this.m_listeners.removeAllElements();
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
    }

    public String toString() {
        String tmp = this.m_date + "," + this.m_description + "," + this.m_depositAmount;
        return tmp;
    }
}

