/*
 * Decompiled with CFR 0.152.
 */
package com.t4d.budget;

import com.t4d.budget.AccountInfoListener;
import com.t4d.budget.AccountModel;
import com.t4d.budget.AccountTransactionListListener;
import com.t4d.budget.InvalidTransactionException;
import com.t4d.budget.JCurrencyField;
import com.t4d.budget.TransactionModel;
import com.t4d.budget.TransactionView;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JViewport;

public class TransactionListView
extends JViewport
implements AccountTransactionListListener,
AccountInfoListener,
ActionListener {
    private AccountModel m_model = null;
    private JPanel m_headRow;
    private JPanel m_addPane;
    private JPanel m_list;
    private JCurrencyField m_totRow;

    public TransactionListView() {
        JPanel content = new JPanel();
        content.setLayout(new BorderLayout());
        JTextField dateRow = new JTextField("", 7);
        dateRow.setHorizontalAlignment(0);
        dateRow.setEditable(false);
        JTextField descRow = new JTextField("Starting Balance", 30);
        descRow.setHorizontalAlignment(2);
        descRow.setEditable(false);
        JTextField debRow = new JTextField("", 10);
        debRow.setHorizontalAlignment(4);
        debRow.setEditable(false);
        JTextField credRow = new JTextField("", 10);
        credRow.setHorizontalAlignment(4);
        credRow.setEditable(false);
        this.m_totRow = new JCurrencyField(0, 10);
        this.m_totRow.setID("StartAmt");
        this.m_totRow.addActionListener(this);
        JTextField xferRow = new JTextField("", 15);
        xferRow.setHorizontalAlignment(0);
        xferRow.setEditable(false);
        this.m_headRow = new JPanel(new FlowLayout(0, 0, 0));
        this.m_headRow.add(dateRow);
        this.m_headRow.add(descRow);
        this.m_headRow.add(debRow);
        this.m_headRow.add(credRow);
        this.m_headRow.add(this.m_totRow);
        this.m_headRow.add(xferRow);
        this.m_addPane = new JPanel(new FlowLayout(1, 0, 0));
        JButton addButt = new JButton("Add a new transaction");
        addButt.addActionListener(this);
        addButt.setFont(new Font("Arial New", 0, 10));
        this.m_addPane.add(addButt);
        this.m_list = new JPanel();
        this.m_list.setLayout(new GridLayout(0, 1, 0, 0));
        this.m_list.add(this.m_headRow);
        this.m_list.add(this.m_addPane);
        content.add((Component)this.m_list, "North");
        this.add(content);
    }

    public TransactionListView(AccountModel model) {
        this();
        this.setModel(model);
    }

    public void setModel(AccountModel model) {
        if (this.m_model != null) {
            this.m_model.removeTransactionListener(this);
            this.m_model.removeInfoListener(this);
        }
        this.m_model = model;
        if (this.m_model != null) {
            this.m_model.addTransactionListener(this);
            this.m_model.addInfoListener(this);
        }
        this.redraw();
    }

    public void accountTransactionListChanged() {
        this.transferFocus();
        this.redraw();
    }

    public void accountInfoChanged() {
        this.redraw();
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("Add a new transaction")) {
            if (this.m_model != null) {
                try {
                    this.m_model.addTransaction(new TransactionModel(new Date(), "", 0, this.m_model));
                }
                catch (InvalidTransactionException ite) {}
            }
        } else if (e.getActionCommand().equals("StartAmt") && this.m_model != null) {
            this.m_model.setStart(((JCurrencyField)e.getSource()).getIntValue());
        }
    }

    private void redraw() {
        Component[] complist = this.m_list.getComponents();
        int i = 0;
        while (i < complist.length) {
            if (complist[i] instanceof TransactionView) {
                ((TransactionView)complist[i]).setModel(null);
            }
            ++i;
        }
        this.m_list.removeAll();
        if (this.m_model == null) {
            this.revalidate();
            return;
        }
        this.m_list.add(this.m_headRow);
        this.m_totRow.setIntValue(this.m_model.getStart());
        int size = this.m_model.getTransactionList().size();
        i = 0;
        while (i < size) {
            TransactionModel tm = (TransactionModel)this.m_model.getTransactionList().get(i);
            TransactionView tv = new TransactionView(tm);
            tv.setLayout(new FlowLayout(0, 0, 0));
            this.m_list.add(tv);
            ++i;
        }
        this.m_list.add(this.m_addPane);
        this.revalidate();
    }
}

