/*
 * Decompiled with CFR 0.152.
 */
package com.t4d.budget;

import com.t4d.budget.AccountModel;
import com.t4d.budget.BudgetModel;
import com.t4d.budget.InvalidAccountException;
import com.t4d.budget.JCurrencyField;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class NewAccountFrame
extends JFrame
implements ActionListener {
    private BudgetModel m_budget;
    private JTextField m_name;
    private JComboBox m_type;
    private JCurrencyField m_start;

    public NewAccountFrame(BudgetModel bm) {
        super("Creating a new account");
        this.m_budget = bm;
        JLabel name = new JLabel("Account name");
        this.m_name = new JTextField();
        this.m_name.setColumns(15);
        JLabel type = new JLabel("Account type");
        String[] types = new String[]{"Checking Account", "Savings Account", "Credit Card"};
        this.m_type = new JComboBox<String>(types);
        JLabel start = new JLabel("Starting balance");
        this.m_start = new JCurrencyField(0, 10);
        JButton okay = new JButton("Okay");
        okay.addActionListener(this);
        JButton cancel = new JButton("Cancel");
        cancel.addActionListener(this);
        JPanel newAccountPane = new JPanel(new BorderLayout());
        JPanel center = new JPanel();
        JPanel south = new JPanel();
        center.add(name);
        center.add(this.m_name);
        center.add(type);
        center.add(this.m_type);
        center.add(start);
        center.add(this.m_start);
        south.add(okay);
        south.add(cancel);
        newAccountPane.add((Component)center, "Center");
        newAccountPane.add((Component)south, "South");
        newAccountPane.revalidate();
        ((Component)this).setSize(300, 200);
        this.getContentPane().add(newAccountPane);
        ((Component)this).setVisible(true);
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("Okay")) {
            AccountModel am = new AccountModel(this.m_name.getText(), this.m_type.getSelectedIndex() + 1, this.m_start.getIntValue());
            if (this.m_budget != null) {
                try {
                    this.m_budget.addAccount(am);
                    this.dispose();
                }
                catch (InvalidAccountException iae) {
                    JOptionPane.showMessageDialog(this, "Duplicate account names are not permitted", "Error!", 0);
                }
            }
        } else if (e.getActionCommand().equals("Cancel")) {
            this.dispose();
        }
    }
}

