/*
 * Decompiled with CFR 0.152.
 */
package com.t4d.budget;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;
import javax.swing.JComponent;

public class MyButton
extends JComponent
implements MouseListener {
    private int m_buttonWidth;
    private int m_buttonHeight;
    private String m_label;
    private Vector m_listeners;
    private boolean m_pressed;
    private boolean m_firstTime;

    public MyButton(String label) {
        this.m_label = label;
        this.m_buttonWidth = 0;
        this.m_buttonHeight = 0;
        this.m_listeners = new Vector();
        this.addMouseListener(this);
        this.m_firstTime = true;
    }

    public void mouseClicked(MouseEvent e) {
        if (!this.m_pressed) {
            this.actionPerformed();
        }
    }

    public void setPressed(boolean pressed) {
        this.m_pressed = pressed;
    }

    public void mousePressed(MouseEvent e) {
        this.m_pressed = true;
        this.repaint();
    }

    public void mouseReleased(MouseEvent e) {
        this.m_pressed = false;
        this.repaint();
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void addActionListener(ActionListener l) {
        if (this.m_listeners.indexOf(l) == -1) {
            this.m_listeners.add(l);
        }
    }

    public void removeActionListener(ActionListener l) {
        if (this.m_listeners.indexOf(l) != -1) {
            this.m_listeners.removeElementAt(this.m_listeners.indexOf(l));
        }
    }

    private void actionPerformed() {
        ActionEvent e = new ActionEvent(this, 1001, this.m_label);
        int size = this.m_listeners.size();
        int i = 0;
        while (i < size) {
            ((ActionListener)this.m_listeners.get(i)).actionPerformed(e);
            ++i;
        }
    }

    public void paintComponent(Graphics g) {
        int maxWidth = 0;
        int totalHeight = 0;
        Font arialFont = new Font("Arial New", 0, 18);
        g.setFont(arialFont);
        FontMetrics fm = g.getFontMetrics();
        maxWidth = fm.stringWidth(String.valueOf(this.m_label) + " Add");
        this.m_buttonWidth = maxWidth += 10;
        this.m_buttonHeight = totalHeight = fm.getHeight() + 10;
        Dimension dim = new Dimension(this.m_buttonWidth, this.m_buttonHeight);
        this.setMinimumSize(dim);
        this.setMaximumSize(dim);
        this.setPreferredSize(dim);
        Point textCenter = new Point(maxWidth - maxWidth / 2, totalHeight / 2 + fm.getAscent() / 2 - fm.getDescent() / 2);
        if (this.m_pressed) {
            g.setColor(Color.white);
            g.fillRoundRect(textCenter.x - maxWidth / 2, 0, maxWidth - 1, totalHeight - 1, 10, 10);
        }
        g.setColor(Color.white);
        g.drawRoundRect(textCenter.x - maxWidth / 2 + 1, 1, maxWidth - 2, totalHeight - 2, 10, 10);
        g.setColor(Color.darkGray);
        g.drawRoundRect(textCenter.x - maxWidth / 2, 0, maxWidth - 2, totalHeight - 2, 10, 10);
        g.setColor(Color.black);
        g.drawString(this.m_label, textCenter.x - fm.stringWidth(this.m_label) / 2, textCenter.y);
        if (this.m_firstTime) {
            this.revalidate();
            this.m_firstTime = false;
        }
    }
}

