/*
 * Decompiled with CFR 0.152.
 */
package com.t4d.budget;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Vector;
import javax.swing.JTextField;

public class JDateField
extends JTextField
implements ActionListener,
FocusListener {
    private Date m_date = new Date();
    private int m_columns = -1;
    private String m_lastVal = "";
    private Vector m_listeners = new Vector();
    private String m_id;

    public JDateField() {
        super.addActionListener(this);
        super.addFocusListener(this);
        this.setHorizontalAlignment(2);
        this.m_id = "JDateField";
    }

    public JDateField(Date d) {
        this();
        this.setDate(d);
    }

    public JDateField(Date d, int columns) {
        this(d);
        this.m_columns = columns;
        this.setColumns(columns);
    }

    public void setDate(Date d) {
        this.m_date = d;
        this.redraw();
    }

    public Date getDate() {
        return this.m_date;
    }

    public void actionPerformed(ActionEvent e) {
        this.readInput();
    }

    public void focusGained(FocusEvent e) {
    }

    public void focusLost(FocusEvent e) {
        this.readInput();
    }

    private void readInput() {
        String dateStr = this.getText();
        if (!dateStr.equals(this.m_lastVal)) {
            SimpleDateFormat sdf = new SimpleDateFormat("MM/dd/yy");
            Date d = null;
            try {
                d = sdf.parse(dateStr);
            }
            catch (ParseException pe) {
                SimpleDateFormat sdf2 = new SimpleDateFormat("MM-dd-yy");
                try {
                    d = sdf2.parse(dateStr);
                }
                catch (ParseException pe2) {
                    System.out.println(pe2);
                }
            }
            if (d != null) {
                this.m_date = d;
            }
            this.actionPerformed();
            this.redraw();
        }
    }

    private void redraw() {
        SimpleDateFormat sdf = new SimpleDateFormat("MM/dd/yyyy");
        this.setText(sdf.format(this.m_date));
        if (this.m_columns != -1) {
            this.setColumns(this.m_columns);
        }
        this.m_lastVal = this.getText();
        this.repaint();
    }

    public void addActionListener(ActionListener l) {
        if (this.m_listeners.indexOf(l) == -1) {
            this.m_listeners.add(l);
        }
    }

    public void removeActionListener(ActionListener l) {
        if (this.m_listeners.indexOf(l) != -1) {
            this.m_listeners.removeElementAt(this.m_listeners.indexOf(l));
        }
    }

    public void setID(String id) {
        this.m_id = id;
    }

    private void actionPerformed() {
        ActionEvent e = new ActionEvent(this, 1001, this.m_id);
        int size = this.m_listeners.size();
        int i = 0;
        while (i < size) {
            ((ActionListener)this.m_listeners.get(i)).actionPerformed(e);
            ++i;
        }
    }
}

