/*
 * Decompiled with CFR 0.152.
 */
package com.t4d.budget;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Vector;
import javax.swing.JTextField;

public class JCurrencyField
extends JTextField
implements ActionListener,
FocusListener {
    private int m_amount = 0;
    private int m_columns = -1;
    private String m_lastVal = "";
    private Vector m_listeners = new Vector();
    private String m_id;

    public JCurrencyField() {
        super.addActionListener(this);
        super.addFocusListener(this);
        this.setHorizontalAlignment(4);
        this.m_id = "JCurrencyField";
    }

    public JCurrencyField(float initialvalue) {
        this();
        this.setFloatValue(initialvalue);
    }

    public JCurrencyField(int initialvalue) {
        this();
        this.setIntValue(initialvalue);
    }

    public JCurrencyField(float initialvalue, int columns) {
        this(initialvalue);
        this.m_columns = columns;
        this.setColumns(columns);
    }

    public JCurrencyField(int initialvalue, int columns) {
        this(initialvalue);
        this.m_columns = columns;
        this.setColumns(columns);
    }

    public void setFloatValue(float value) {
        this.m_amount = Math.round(value * 100.0f);
        this.redraw();
    }

    public float getFloatValue() {
        return (float)this.m_amount / 100.0f;
    }

    public void setIntValue(int value) {
        this.m_amount = value;
        this.redraw();
    }

    public int getIntValue() {
        return this.m_amount;
    }

    public void actionPerformed(ActionEvent e) {
        this.readInput();
    }

    public void focusGained(FocusEvent e) {
    }

    public void focusLost(FocusEvent e) {
        this.readInput();
    }

    private void readInput() {
        String curStr = this.getText();
        if (!curStr.equals(this.m_lastVal)) {
            NumberFormat nf = NumberFormat.getCurrencyInstance();
            Number curNum = null;
            try {
                curNum = nf.parse(curStr);
            }
            catch (ParseException pe) {
                NumberFormat nf2 = NumberFormat.getNumberInstance();
                try {
                    curNum = nf2.parse(curStr);
                }
                catch (ParseException pe2) {
                    System.out.println(pe2);
                }
            }
            if (curNum != null) {
                this.m_amount = (int)Math.round(curNum.doubleValue() * 100.0);
            }
            this.actionPerformed();
            this.redraw();
        }
    }

    private void redraw() {
        NumberFormat nf = NumberFormat.getCurrencyInstance();
        this.setText(nf.format((double)this.m_amount / 100.0));
        if (this.m_columns != -1) {
            this.setColumns(this.m_columns);
        }
        this.m_lastVal = this.getText();
        this.repaint();
    }

    public void addActionListener(ActionListener l) {
        if (this.m_listeners.indexOf(l) == -1) {
            this.m_listeners.add(l);
        }
    }

    public void removeActionListener(ActionListener l) {
        if (this.m_listeners.indexOf(l) != -1) {
            this.m_listeners.removeElementAt(this.m_listeners.indexOf(l));
        }
    }

    public void setID(String id) {
        this.m_id = id;
    }

    private void actionPerformed() {
        ActionEvent e = new ActionEvent(this, 1001, this.m_id);
        int size = this.m_listeners.size();
        int i = 0;
        while (i < size) {
            ((ActionListener)this.m_listeners.get(i)).actionPerformed(e);
            ++i;
        }
    }
}

