/*
 * Decompiled with CFR 0.152.
 */
package com.t4d.budget;

import com.t4d.budget.GraphViewerAccountModel;
import com.t4d.budget.GraphViewerListener;
import com.t4d.budget.GraphViewerModel;
import com.t4d.budget.GraphViewerTransactionModel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.JComponent;

public class GraphViewerView
extends JComponent
implements GraphViewerListener,
MouseListener {
    private GraphViewerModel m_gvm;
    private int m_legendWidth = 0;
    private int m_legendHeight = 0;
    private int m_hgrid = 10;
    private int m_vgrid = 10;
    private int m_graphWidth;
    private int m_graphHeight;
    private int m_vmultiplier;
    private long m_hmultiplier;
    private int m_miny;
    private Date m_mindate;
    private int m_pickedX;
    private int m_pickedY;
    private Color m_bgcolor;

    public GraphViewerView(GraphViewerModel gvm) {
        this.m_gvm = gvm;
        this.setPreferredSize(new Dimension(800, 600));
        this.addMouseListener(this);
        this.m_gvm.addListener(this);
        this.m_pickedX = -1;
        this.m_pickedY = -1;
        this.m_vmultiplier = 1;
        this.m_hmultiplier = 1L;
        this.m_bgcolor = Color.darkGray;
        this.revalidate();
    }

    public void graphViewerChanged() {
        this.repaint();
    }

    public void setBackgroundColor(Color color) {
        if (color != null) {
            this.m_bgcolor = color;
        }
        this.repaint();
    }

    public void paintComponent(Graphics g) {
        int height = this.getHeight() - 10;
        int width = this.getWidth() - 10;
        long lastx = 0L;
        int lasty = 0;
        int maxy = 0;
        this.m_miny = 0;
        int total = 0;
        boolean firsty = true;
        boolean firstx = true;
        this.m_mindate = new Date();
        Date maxdate = new Date();
        Font arialFont = new Font("Arial New", 0, 10);
        g.setFont(arialFont);
        FontMetrics fm = g.getFontMetrics();
        int size = this.m_gvm.getAccounts().size();
        int i = 0;
        while (i < size) {
            total = 0;
            GraphViewerAccountModel gvam = (GraphViewerAccountModel)this.m_gvm.getAccounts().get(i);
            if (gvam.getVisible()) {
                if (firsty || this.m_miny > gvam.getAmount()) {
                    this.m_miny = gvam.getAmount();
                }
                if (firsty || maxy < gvam.getAmount()) {
                    maxy = gvam.getAmount();
                }
                firsty = false;
                total += gvam.getAmount();
                int jsize = gvam.getTransactions().size();
                int j = 0;
                while (j < jsize) {
                    GraphViewerTransactionModel gvtm = (GraphViewerTransactionModel)gvam.getTransactions().get(j);
                    if (this.m_miny > (total += gvtm.getAmount())) {
                        this.m_miny = total;
                    }
                    if (maxy < total) {
                        maxy = total;
                    }
                    ++j;
                }
            }
            ++i;
        }
        this.m_legendHeight = fm.getHeight() + 10;
        this.m_legendWidth = fm.stringWidth(String.valueOf(String.valueOf(maxy)) + ".$   ") + 20;
        this.m_mindate = this.m_gvm.getStartDate();
        maxdate = this.m_gvm.getEndDate();
        if (!this.m_mindate.before(maxdate)) {
            maxdate.setTime(maxdate.getTime() + 86400L);
        }
        if (this.m_graphHeight != height - this.m_legendHeight) {
            this.m_pickedY = -1;
        }
        if (this.m_graphWidth != width - this.m_legendWidth) {
            this.m_pickedX = -1;
        }
        this.m_graphHeight = height - this.m_legendHeight;
        this.m_graphWidth = width - this.m_legendWidth;
        if (this.m_graphHeight != 0) {
            if (this.m_vmultiplier != (maxy - this.m_miny) / this.m_graphHeight) {
                this.m_pickedY = -1;
            }
            this.m_vmultiplier = (maxy - this.m_miny) / this.m_graphHeight;
        }
        if (this.m_graphWidth != 0) {
            if (this.m_hmultiplier != (maxdate.getTime() - this.m_mindate.getTime()) / (long)this.m_graphWidth) {
                this.m_pickedX = -1;
            }
            this.m_hmultiplier = (maxdate.getTime() - this.m_mindate.getTime()) / (long)this.m_graphWidth;
        }
        if (this.m_hmultiplier == 0L) {
            this.m_hmultiplier = 1L;
        }
        if (this.m_vmultiplier == 0) {
            this.m_vmultiplier = 1;
        }
        this.m_vgrid = this.m_graphHeight / 100 + 1;
        this.m_hgrid = this.m_graphWidth / 100 + 1;
        g.setColor(this.m_bgcolor);
        g.fillRect(this.m_legendWidth, 0, this.m_graphWidth, (maxy - this.m_miny) / this.m_vmultiplier);
        long vinc = (maxdate.getTime() - this.m_mindate.getTime()) / (long)this.m_hgrid;
        int hinc = (maxy - this.m_miny) / this.m_vgrid;
        if (this.m_miny < 0 && maxy > 0) {
            if (this.m_bgcolor.equals(Color.black) || this.m_bgcolor.equals(Color.darkGray)) {
                g.setColor(Color.white);
            } else {
                g.setColor(Color.black);
            }
            g.setColor(Color.lightGray);
            g.drawLine(this.m_legendWidth - 10, (maxy - this.m_miny) / this.m_vmultiplier + this.m_miny / this.m_vmultiplier, width, (maxy - this.m_miny) / this.m_vmultiplier + this.m_miny / this.m_vmultiplier);
        }
        i = 0;
        while (i <= this.m_hgrid) {
            if (this.m_bgcolor.equals(Color.black) || this.m_bgcolor.equals(Color.darkGray)) {
                g.setColor(Color.gray);
            } else {
                g.setColor(Color.darkGray);
            }
            g.drawLine((int)((long)this.m_legendWidth + (long)i * vinc / this.m_hmultiplier), 0, (int)((long)this.m_legendWidth + (long)i * vinc / this.m_hmultiplier), this.m_graphHeight + 10);
            Date d = new Date((long)i * vinc + this.m_mindate.getTime());
            SimpleDateFormat sdf = new SimpleDateFormat("MM/dd/yyyy");
            String dateStr = sdf.format(d);
            g.setColor(Color.black);
            if (i == 0) {
                g.drawString(dateStr, (int)((long)this.m_legendWidth + (long)i * vinc / this.m_hmultiplier), this.m_graphHeight + 10 + fm.getAscent());
            } else if (i != this.m_hgrid) {
                g.drawString(dateStr, (int)((long)this.m_legendWidth + (long)i * vinc / this.m_hmultiplier) - fm.stringWidth(dateStr) / 2, this.m_graphHeight + 10 + fm.getAscent());
            } else {
                g.drawString(dateStr, (int)((long)this.m_legendWidth + (long)i * vinc / this.m_hmultiplier) - fm.stringWidth(dateStr), this.m_graphHeight + 10 + fm.getAscent());
            }
            ++i;
        }
        i = 0;
        while (i <= this.m_vgrid) {
            if (this.m_bgcolor.equals(Color.black) || this.m_bgcolor.equals(Color.darkGray)) {
                g.setColor(Color.gray);
            } else {
                g.setColor(Color.darkGray);
            }
            g.drawLine(this.m_legendWidth - 10, (maxy - this.m_miny) / this.m_vmultiplier - i * hinc / this.m_vmultiplier, width, (maxy - this.m_miny) / this.m_vmultiplier - i * hinc / this.m_vmultiplier);
            int amt = i * (maxy - this.m_miny) / this.m_vgrid + this.m_miny;
            String amtStr = null;
            amtStr = amt < 0 ? "$" + amt / 100 + "." + -amt % 100 / 10 + -amt % 10 : "$" + amt / 100 + "." + amt % 100 / 10 + amt % 10;
            g.setColor(Color.black);
            if (i == 0) {
                g.drawString(amtStr, 0, (maxy - this.m_miny) / this.m_vmultiplier - i * hinc / this.m_vmultiplier);
            } else if (i != this.m_vgrid) {
                g.drawString(amtStr, 0, (maxy - this.m_miny) / this.m_vmultiplier + fm.getAscent() / 2 - i * hinc / this.m_vmultiplier);
            } else {
                g.drawString(amtStr, 0, (maxy - this.m_miny) / this.m_vmultiplier + fm.getAscent() - i * hinc / this.m_vmultiplier);
            }
            ++i;
        }
        size = this.m_gvm.getAccounts().size();
        i = 0;
        while (i < size) {
            total = 0;
            GraphViewerAccountModel gvam = (GraphViewerAccountModel)this.m_gvm.getAccounts().get(i);
            lastx = 0L;
            lasty = (total += gvam.getAmount()) / this.m_vmultiplier;
            g.setColor(gvam.getColor());
            if (gvam.getVisible()) {
                int jsize = gvam.getTransactions().size();
                int j = 0;
                while (j < jsize) {
                    GraphViewerTransactionModel gvtm = (GraphViewerTransactionModel)gvam.getTransactions().get(j);
                    long newx = (gvtm.getDate().getTime() - this.m_mindate.getTime()) / this.m_hmultiplier;
                    int newy = (total += gvtm.getAmount()) / this.m_vmultiplier;
                    g.drawLine((int)lastx + this.m_legendWidth, (maxy - this.m_miny) / this.m_vmultiplier - (lasty - this.m_miny / this.m_vmultiplier), (int)newx + this.m_legendWidth, (maxy - this.m_miny) / this.m_vmultiplier - (newy - this.m_miny / this.m_vmultiplier));
                    lastx = newx;
                    lasty = newy;
                    ++j;
                }
            }
            ++i;
        }
        if (this.m_pickedX != -1 && this.m_pickedY != -1) {
            Date d = new Date();
            d.setTime((long)this.m_pickedX * this.m_hmultiplier + this.m_mindate.getTime());
            SimpleDateFormat sdf = new SimpleDateFormat("MM/dd/yyyy");
            int amt = this.m_pickedY * this.m_vmultiplier + this.m_miny;
            String dateStr = sdf.format(d);
            dateStr = String.valueOf(dateStr) + ", $" + amt / 100 + ".";
            if (amt < 0) {
                amt = -amt;
            }
            dateStr = String.valueOf(dateStr) + amt % 100 / 10;
            dateStr = String.valueOf(dateStr) + amt % 10;
            g.setColor(Color.white);
            g.drawString(dateStr, this.m_legendWidth + 5, fm.getAscent());
            g.drawLine(this.m_legendWidth + this.m_pickedX - 2, this.m_graphHeight - this.m_pickedY - 2, this.m_legendWidth + this.m_pickedX + 2, this.m_graphHeight - this.m_pickedY + 2);
            g.drawLine(this.m_legendWidth + this.m_pickedX - 2, this.m_graphHeight - this.m_pickedY + 2, this.m_legendWidth + this.m_pickedX + 2, this.m_graphHeight - this.m_pickedY - 2);
        }
    }

    public void mouseClicked(MouseEvent e) {
        if (e.getY() <= this.m_graphHeight && e.getX() > this.m_legendWidth && e.getX() < this.m_legendWidth + this.m_graphWidth) {
            if (e.getButton() == 1) {
                this.m_pickedX = e.getX() - this.m_legendWidth;
                this.m_pickedY = this.m_graphHeight - e.getY();
            } else {
                this.m_pickedX = -1;
                this.m_pickedY = -1;
            }
            this.repaint();
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }
}

