/*
 * Decompiled with CFR 0.152.
 */
package com.t4d.budget;

import com.t4d.budget.AccountBudgetListListener;
import com.t4d.budget.AccountInfoListener;
import com.t4d.budget.AccountListListener;
import com.t4d.budget.AccountModel;
import com.t4d.budget.AccountTransactionListListener;
import com.t4d.budget.BudgetModel;
import com.t4d.budget.BudgetTransactionListener;
import com.t4d.budget.BudgetTransactionModel;
import com.t4d.budget.GraphViewerAccountModel;
import com.t4d.budget.GraphViewerListener;
import com.t4d.budget.GraphViewerTransactionModel;
import com.t4d.budget.TransactionListener;
import com.t4d.budget.TransactionModel;
import java.awt.Color;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Vector;

public class GraphViewerModel
implements AccountListListener,
AccountInfoListener,
AccountTransactionListListener,
AccountBudgetListListener,
TransactionListener,
BudgetTransactionListener {
    private BudgetModel m_budget;
    private Vector m_accounts;
    private int m_hgridSpacing;
    private int m_vgridSpacing;
    private Date m_startDate;
    private Date m_endDate;
    private Vector m_listeners;
    private boolean m_initialized = false;

    public GraphViewerModel(BudgetModel bm, Date start, Date end) {
        this.setBudget(bm);
        this.m_accounts = new Vector();
        this.m_listeners = new Vector();
        this.m_hgridSpacing = -1;
        this.m_vgridSpacing = -1;
        this.m_startDate = null;
        this.m_endDate = null;
        this.setStartDate(start);
        this.m_initialized = true;
        this.setEndDate(end);
    }

    public void setBudget(BudgetModel bm) {
        if (this.m_budget != null) {
            this.m_budget.removeAccountListListener(this);
        }
        this.m_budget = bm;
        if (this.m_budget != null) {
            this.m_budget.addAccountListListener(this);
        }
        if (this.m_initialized) {
            this.graphViewerChanged();
        }
    }

    public void setStartDate(Date start) {
        if (this.m_endDate != null) {
            if (start.after(this.m_endDate)) {
                this.m_endDate = start;
            }
        } else {
            this.m_endDate = start;
        }
        this.m_startDate = start;
        if (this.m_initialized) {
            this.graphViewerChanged();
        }
    }

    public Date getStartDate() {
        return this.m_startDate;
    }

    public void setEndDate(Date end) {
        if (this.m_startDate != null) {
            if (end.before(this.m_startDate)) {
                this.m_startDate = end;
            }
        } else {
            this.m_startDate = end;
        }
        this.m_endDate = end;
        if (this.m_initialized) {
            this.graphViewerChanged();
        }
    }

    public Date getEndDate() {
        return this.m_endDate;
    }

    public void addListener(GraphViewerListener gvl) {
        if (this.m_listeners.indexOf(gvl) == -1) {
            this.m_listeners.add(gvl);
        }
    }

    public void removeListener(GraphViewerListener gvl) {
        if (this.m_listeners.indexOf(gvl) != -1) {
            this.m_listeners.remove(gvl);
        }
    }

    public void graphViewerChanged() {
        Vector tmpAccounts = new Vector();
        int size = this.m_accounts.size();
        int i = 0;
        while (i < size) {
            ((GraphViewerAccountModel)this.m_accounts.get(i)).removeAllTransactions();
            tmpAccounts.add(this.m_accounts.get(i));
            ++i;
        }
        this.m_accounts.removeAllElements();
        if (this.m_budget != null) {
            Color color = Color.red;
            boolean visible = true;
            boolean tmpfound = false;
            int tmpsize = tmpAccounts.size();
            int tmpi = 0;
            while (tmpi < tmpsize && !tmpfound) {
                GraphViewerAccountModel tmp = (GraphViewerAccountModel)tmpAccounts.get(tmpi);
                if (tmp.getName().equals("Total")) {
                    color = tmp.getColor();
                    visible = tmp.getVisible();
                    tmpAccounts.removeElementAt(tmpi);
                    tmpfound = true;
                }
                ++tmpi;
            }
            GraphViewerAccountModel total = new GraphViewerAccountModel("Total", visible, color, 0);
            this.m_accounts.add(total);
            Vector accounts = this.m_budget.getAccounts();
            if (accounts != null) {
                int asize = accounts.size();
                int ai = 0;
                while (ai < asize) {
                    Vector btransactions;
                    AccountModel am = (AccountModel)accounts.get(ai);
                    am.addBudgetListener(this);
                    am.addTransactionListener(this);
                    am.addInfoListener(this);
                    color = null;
                    visible = true;
                    switch (ai % 7) {
                        case 0: {
                            color = Color.blue;
                            break;
                        }
                        case 1: {
                            color = Color.green;
                            break;
                        }
                        case 2: {
                            color = Color.cyan;
                            break;
                        }
                        case 3: {
                            color = Color.magenta;
                            break;
                        }
                        case 4: {
                            color = Color.orange;
                            break;
                        }
                        case 5: {
                            color = Color.yellow;
                            break;
                        }
                        case 6: {
                            color = Color.pink;
                        }
                    }
                    tmpfound = false;
                    tmpsize = tmpAccounts.size();
                    tmpi = 0;
                    while (tmpi < tmpsize && !tmpfound) {
                        GraphViewerAccountModel tmp = (GraphViewerAccountModel)tmpAccounts.get(tmpi);
                        if (tmp.getName().equals(am.getName())) {
                            color = tmp.getColor();
                            visible = tmp.getVisible();
                            tmpAccounts.removeElementAt(tmpi);
                            tmpfound = true;
                        }
                        ++tmpi;
                    }
                    GraphViewerAccountModel gvam = new GraphViewerAccountModel(am.getName(), visible, color, am.getStart());
                    total.setAmount(total.getAmount() + am.getStart());
                    this.m_accounts.add(gvam);
                    Vector transactions = am.getTransactionList();
                    if (transactions != null) {
                        int tsize = transactions.size();
                        int ti = 0;
                        while (ti < tsize) {
                            TransactionModel tm = (TransactionModel)transactions.get(ti);
                            tm.addTransactionListener(this);
                            if (!tm.getDate().before(this.m_startDate) && !tm.getDate().after(this.m_endDate)) {
                                GraphViewerTransactionModel gvtm = new GraphViewerTransactionModel(tm.getDate(), tm.getAmount());
                                gvam.addTransaction(gvtm);
                                total.addTransaction(gvtm);
                            }
                            if (tm.getDate().before(this.m_startDate)) {
                                total.setAmount(total.getAmount() + tm.getAmount());
                                gvam.setAmount(gvam.getAmount() + tm.getAmount());
                            }
                            ++ti;
                        }
                    }
                    if ((btransactions = am.getBudgetTransactionList()) != null) {
                        int bsize = btransactions.size();
                        int bi = 0;
                        while (bi < bsize) {
                            BudgetTransactionModel btm = (BudgetTransactionModel)btransactions.get(bi);
                            btm.addBudgetTransactionListener(this);
                            if (!btm.getStartDate().after(this.m_endDate)) {
                                GraphViewerTransactionModel gvtm = new GraphViewerTransactionModel(btm.getStartDate(), btm.getAmount());
                                Date d = btm.getStartDate();
                                if (!d.before(this.m_startDate) && !d.after(this.m_endDate)) {
                                    gvam.addTransaction(gvtm);
                                    total.addTransaction(gvtm);
                                }
                                if (d.before(this.m_startDate)) {
                                    total.setAmount(total.getAmount() + btm.getAmount());
                                    gvam.setAmount(gvam.getAmount() + btm.getAmount());
                                }
                                boolean repeat = true;
                                if (btm.getFrequency() == 0) {
                                    repeat = false;
                                }
                                while (repeat) {
                                    GraphViewerTransactionModel gvtm2;
                                    GregorianCalendar calcomp;
                                    GregorianCalendar cal;
                                    if (btm.getFrequency() == 1) {
                                        cal = new GregorianCalendar();
                                        calcomp = new GregorianCalendar();
                                        calcomp.setTime(d);
                                        cal.set(1, calcomp.get(1));
                                        cal.set(2, calcomp.get(2));
                                        cal.set(5, calcomp.get(5) + 7);
                                        d = cal.getTime();
                                        if (!d.after(this.m_endDate) && !d.after(btm.getEndDate())) {
                                            if (!d.before(this.m_startDate)) {
                                                gvtm2 = new GraphViewerTransactionModel(d, btm.getAmount());
                                                gvam.addTransaction(gvtm2);
                                                total.addTransaction(gvtm2);
                                                continue;
                                            }
                                            total.setAmount(total.getAmount() + btm.getAmount());
                                            gvam.setAmount(gvam.getAmount() + btm.getAmount());
                                            continue;
                                        }
                                        repeat = false;
                                        continue;
                                    }
                                    if (btm.getFrequency() == 2) {
                                        cal = new GregorianCalendar();
                                        calcomp = new GregorianCalendar();
                                        calcomp.setTime(d);
                                        cal.set(1, calcomp.get(1));
                                        cal.set(2, calcomp.get(2));
                                        cal.set(5, calcomp.get(5) + 14);
                                        d = cal.getTime();
                                        if (!d.after(this.m_endDate) && !d.after(btm.getEndDate())) {
                                            if (!d.before(this.m_startDate)) {
                                                gvtm2 = new GraphViewerTransactionModel(d, btm.getAmount());
                                                gvam.addTransaction(gvtm2);
                                                total.addTransaction(gvtm2);
                                                continue;
                                            }
                                            total.setAmount(total.getAmount() + btm.getAmount());
                                            gvam.setAmount(gvam.getAmount() + btm.getAmount());
                                            continue;
                                        }
                                        repeat = false;
                                        continue;
                                    }
                                    if (btm.getFrequency() == 3) {
                                        cal = new GregorianCalendar();
                                        calcomp = new GregorianCalendar();
                                        calcomp.setTime(d);
                                        cal.set(1, calcomp.get(1));
                                        cal.set(2, calcomp.get(2) + 1);
                                        cal.set(5, calcomp.get(5));
                                        d = cal.getTime();
                                        if (!d.after(this.m_endDate) && !d.after(btm.getEndDate())) {
                                            if (!d.before(this.m_startDate)) {
                                                gvtm2 = new GraphViewerTransactionModel(d, btm.getAmount());
                                                gvam.addTransaction(gvtm2);
                                                total.addTransaction(gvtm2);
                                                continue;
                                            }
                                            total.setAmount(total.getAmount() + btm.getAmount());
                                            gvam.setAmount(gvam.getAmount() + btm.getAmount());
                                            continue;
                                        }
                                        repeat = false;
                                        continue;
                                    }
                                    if (btm.getFrequency() == 4) {
                                        cal = new GregorianCalendar();
                                        calcomp = new GregorianCalendar();
                                        calcomp.setTime(d);
                                        cal.set(1, calcomp.get(1));
                                        cal.set(2, calcomp.get(2) + 2);
                                        cal.set(5, calcomp.get(5));
                                        d = cal.getTime();
                                        if (!d.after(this.m_endDate) && !d.after(btm.getEndDate())) {
                                            if (!d.before(this.m_startDate)) {
                                                gvtm2 = new GraphViewerTransactionModel(d, btm.getAmount());
                                                gvam.addTransaction(gvtm2);
                                                total.addTransaction(gvtm2);
                                                continue;
                                            }
                                            total.setAmount(total.getAmount() + btm.getAmount());
                                            gvam.setAmount(gvam.getAmount() + btm.getAmount());
                                            continue;
                                        }
                                        repeat = false;
                                        continue;
                                    }
                                    if (btm.getFrequency() == 5) {
                                        cal = new GregorianCalendar();
                                        calcomp = new GregorianCalendar();
                                        calcomp.setTime(d);
                                        cal.set(1, calcomp.get(1));
                                        cal.set(2, calcomp.get(2) + 3);
                                        cal.set(5, calcomp.get(5));
                                        d = cal.getTime();
                                        if (!d.after(this.m_endDate) && !d.after(btm.getEndDate())) {
                                            if (!d.before(this.m_startDate)) {
                                                gvtm2 = new GraphViewerTransactionModel(d, btm.getAmount());
                                                gvam.addTransaction(gvtm2);
                                                total.addTransaction(gvtm2);
                                                continue;
                                            }
                                            total.setAmount(total.getAmount() + btm.getAmount());
                                            gvam.setAmount(gvam.getAmount() + btm.getAmount());
                                            continue;
                                        }
                                        repeat = false;
                                        continue;
                                    }
                                    if (btm.getFrequency() == 6) {
                                        cal = new GregorianCalendar();
                                        calcomp = new GregorianCalendar();
                                        calcomp.setTime(d);
                                        cal.set(1, calcomp.get(1));
                                        cal.set(2, calcomp.get(2) + 6);
                                        cal.set(5, calcomp.get(5));
                                        d = cal.getTime();
                                        if (!d.after(this.m_endDate) && !d.after(btm.getEndDate())) {
                                            if (!d.before(this.m_startDate)) {
                                                gvtm2 = new GraphViewerTransactionModel(d, btm.getAmount());
                                                gvam.addTransaction(gvtm2);
                                                total.addTransaction(gvtm2);
                                                continue;
                                            }
                                            total.setAmount(total.getAmount() + btm.getAmount());
                                            gvam.setAmount(gvam.getAmount() + btm.getAmount());
                                            continue;
                                        }
                                        repeat = false;
                                        continue;
                                    }
                                    if (btm.getFrequency() != 7) continue;
                                    cal = new GregorianCalendar();
                                    calcomp = new GregorianCalendar();
                                    calcomp.setTime(d);
                                    cal.set(1, calcomp.get(1) + 1);
                                    cal.set(2, calcomp.get(2));
                                    cal.set(5, calcomp.get(5));
                                    d = cal.getTime();
                                    if (!d.after(this.m_endDate) && !d.after(btm.getEndDate())) {
                                        if (!d.before(this.m_startDate)) {
                                            gvtm2 = new GraphViewerTransactionModel(d, btm.getAmount());
                                            gvam.addTransaction(gvtm2);
                                            total.addTransaction(gvtm2);
                                            continue;
                                        }
                                        total.setAmount(total.getAmount() + btm.getAmount());
                                        gvam.setAmount(gvam.getAmount() + btm.getAmount());
                                        continue;
                                    }
                                    repeat = false;
                                }
                            }
                            ++bi;
                        }
                    }
                    ++ai;
                }
            }
        }
        size = this.m_listeners.size();
        i = 0;
        while (i < size) {
            GraphViewerListener gvl = (GraphViewerListener)this.m_listeners.get(i);
            gvl.graphViewerChanged();
            ++i;
        }
    }

    public Vector getAccounts() {
        return this.m_accounts;
    }

    public void accountBudgetListChanged() {
        this.graphViewerChanged();
    }

    public void accountTransactionListChanged() {
        this.graphViewerChanged();
    }

    public void accountInfoChanged() {
        this.graphViewerChanged();
    }

    public void accountListChanged() {
        this.graphViewerChanged();
    }

    public void budgetTransactionInfoChanged() {
        this.graphViewerChanged();
    }

    public void transactionInfoChanged() {
        this.graphViewerChanged();
    }
}

