/*
 * Decompiled with CFR 0.152.
 */
package com.t4d.budget;

import com.t4d.budget.GraphViewerAccountModel;
import com.t4d.budget.GraphViewerColorRenderer;
import com.t4d.budget.GraphViewerListener;
import com.t4d.budget.GraphViewerModel;
import com.t4d.budget.GraphViewerView;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class GraphViewerControlPanel
extends JPanel
implements GraphViewerListener,
ActionListener {
    private Vector m_xboxes;
    private Vector m_labels;
    private Vector m_colors;
    private GraphViewerModel m_gvm;
    private GraphViewerView m_gvv;

    public GraphViewerControlPanel(GraphViewerModel gvm, GraphViewerView gvv) {
        this.m_gvm = gvm;
        this.m_gvv = gvv;
        if (this.m_gvm != null) {
            this.m_gvm.addListener(this);
        }
        this.m_xboxes = new Vector();
        this.m_labels = new Vector();
        this.m_colors = new Vector();
        this.redraw();
    }

    private void redraw() {
        this.m_xboxes.removeAllElements();
        this.m_labels.removeAllElements();
        this.m_colors.removeAllElements();
        this.removeAll();
        this.setLayout(new BorderLayout(0, 0));
        JPanel content = new JPanel(new GridLayout(0, 1, 20, 20));
        this.add((Component)content, "North");
        if (this.m_gvm != null && this.m_gvm.getAccounts() != null) {
            int size = this.m_gvm.getAccounts().size();
            int i = 0;
            while (i < size) {
                GraphViewerAccountModel gvam = (GraphViewerAccountModel)this.m_gvm.getAccounts().get(i);
                JCheckBox jxb = new JCheckBox();
                jxb.setSelected(gvam.getVisible());
                this.m_xboxes.add(jxb);
                jxb.addActionListener(this);
                JLabel jl = new JLabel(gvam.getName());
                this.m_labels.add(jl);
                String[] elements = new String[]{"Blue", "Cyan", "Green", "Magenta", "Orange", "Pink", "Red", "Yellow"};
                JComboBox<String> jcb = new JComboBox<String>(elements);
                jcb.setRenderer(new GraphViewerColorRenderer());
                Color color = gvam.getColor();
                if (color.equals(Color.black)) {
                    jcb.setSelectedItem("Black");
                } else if (color.equals(Color.blue)) {
                    jcb.setSelectedItem("Blue");
                } else if (color.equals(Color.cyan)) {
                    jcb.setSelectedItem("Cyan");
                } else if (color.equals(Color.green)) {
                    jcb.setSelectedItem("Green");
                } else if (color.equals(Color.magenta)) {
                    jcb.setSelectedItem("Magenta");
                } else if (color.equals(Color.orange)) {
                    jcb.setSelectedItem("Orange");
                } else if (color.equals(Color.pink)) {
                    jcb.setSelectedItem("Pink");
                } else if (color.equals(Color.red)) {
                    jcb.setSelectedItem("Red");
                } else if (color.equals(Color.white)) {
                    jcb.setSelectedItem("White");
                } else if (color.equals(Color.yellow)) {
                    jcb.setSelectedItem("Yellow");
                }
                this.m_colors.add(jcb);
                jcb.addActionListener(this);
                JPanel jp = new JPanel(new BorderLayout(0, 0));
                JPanel jp2 = new JPanel(new FlowLayout(0));
                jp2.add(jxb);
                jp2.add(jl);
                jp.add((Component)jp2, "North");
                jp.add(jcb, "Center");
                content.add(jp);
                ++i;
            }
        }
        this.revalidate();
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        int index = this.m_xboxes.indexOf(source);
        if (index != -1) {
            if (this.m_gvm != null && this.m_gvm.getAccounts() != null) {
                GraphViewerAccountModel gvam;
                gvam.setVisible(!(gvam = (GraphViewerAccountModel)this.m_gvm.getAccounts().get(index)).getVisible());
                this.m_gvm.graphViewerChanged();
            }
        } else {
            index = this.m_colors.indexOf(source);
            if (index != -1 && this.m_gvm != null && this.m_gvm.getAccounts() != null) {
                String clr = (String)((JComboBox)source).getSelectedItem();
                Color color = null;
                if (clr.equals("Red")) {
                    color = Color.red;
                } else if (clr.equals("Blue")) {
                    color = Color.blue;
                } else if (clr.equals("Black")) {
                    color = Color.black;
                } else if (clr.equals("Cyan")) {
                    color = Color.cyan;
                } else if (clr.equals("Green")) {
                    color = Color.green;
                } else if (clr.equals("Magenta")) {
                    color = Color.magenta;
                } else if (clr.equals("Orange")) {
                    color = Color.orange;
                } else if (clr.equals("Pink")) {
                    color = Color.pink;
                } else if (clr.equals("White")) {
                    color = Color.white;
                } else if (clr.equals("Yellow")) {
                    color = Color.yellow;
                }
                if (color != null) {
                    GraphViewerAccountModel gvam = (GraphViewerAccountModel)this.m_gvm.getAccounts().get(index);
                    gvam.setColor(color);
                }
                if (this.m_gvv != null) {
                    this.m_gvv.repaint();
                }
            }
        }
    }

    public void graphViewerChanged() {
        this.redraw();
    }
}

