/*
 * Decompiled with CFR 0.152.
 */
package com.t4d.budget;

import com.t4d.budget.GraphViewerTransactionModel;
import java.awt.Color;
import java.util.Vector;

public class GraphViewerAccountModel {
    private Vector m_transactions;
    private String m_name;
    private boolean m_visible;
    private Color m_color;
    private int m_start;

    public GraphViewerAccountModel(String name, boolean visible, Color color, int amt) {
        this.m_name = name;
        this.m_visible = visible;
        this.m_color = color;
        this.m_transactions = new Vector();
        this.m_start = amt;
    }

    public boolean getVisible() {
        return this.m_visible;
    }

    public void setVisible(boolean visible) {
        this.m_visible = visible;
    }

    public Color getColor() {
        return this.m_color;
    }

    public void setColor(Color color) {
        this.m_color = color;
    }

    public void addTransaction(GraphViewerTransactionModel gvtm) {
        int insertHere = -1;
        if (this.m_transactions.indexOf(gvtm) == -1) {
            int size = this.m_transactions.size();
            int i = 0;
            while (i < size) {
                GraphViewerTransactionModel tm = (GraphViewerTransactionModel)this.m_transactions.get(i);
                if (tm.getDate().after(gvtm.getDate())) {
                    insertHere = i;
                    i = size;
                }
                ++i;
            }
            if (insertHere != -1) {
                this.m_transactions.insertElementAt(gvtm, insertHere);
            } else {
                this.m_transactions.add(gvtm);
            }
        }
    }

    public void removeAllTransactions() {
        this.m_transactions.removeAllElements();
    }

    public Vector getTransactions() {
        return this.m_transactions;
    }

    public int getAmount() {
        return this.m_start;
    }

    public void setAmount(int start) {
        this.m_start = start;
    }

    public String getName() {
        return this.m_name;
    }

    public void setName(String name) {
        this.m_name = name;
    }
}

