/*
 * Decompiled with CFR 0.152.
 */
package com.t4d.budget;

import com.t4d.budget.AccountListListener;
import com.t4d.budget.AccountModel;
import com.t4d.budget.BudgetListener;
import com.t4d.budget.BudgetModel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JComponent;

public class BudgetView
extends JComponent
implements AccountListListener,
BudgetListener,
MouseListener {
    private BudgetModel m_model;
    private int m_totalHeight;
    private int m_maxWidth;
    private int m_arrowWidth;
    private int m_arrowHeight;
    private int m_numVisible;
    private int m_numTotal;
    private int m_firstVisible;
    private JComponent m_container;
    private int m_pressedThing;

    public BudgetView() {
        this.m_model = null;
        this.m_firstVisible = 0;
        this.m_arrowWidth = 0;
        this.m_arrowHeight = 0;
        this.m_numVisible = 0;
        this.m_numTotal = 0;
        this.m_totalHeight = 0;
        this.m_maxWidth = 0;
        this.m_container = null;
        this.addMouseListener(this);
        this.m_pressedThing = -3;
    }

    public BudgetView(BudgetModel bm) {
        this.m_model = bm;
        this.m_firstVisible = 0;
        this.m_arrowWidth = 0;
        this.m_arrowHeight = 0;
        this.m_numVisible = 0;
        this.m_numTotal = 0;
        this.m_totalHeight = 0;
        this.m_maxWidth = 0;
        this.m_container = null;
        this.addMouseListener(this);
        this.m_pressedThing = -3;
    }

    public BudgetView(BudgetModel bm, JComponent container) {
        this.m_model = bm;
        this.m_firstVisible = 0;
        this.m_arrowWidth = 0;
        this.m_arrowHeight = 0;
        this.m_numVisible = 0;
        this.m_numTotal = 0;
        this.m_totalHeight = 0;
        this.m_maxWidth = 0;
        this.m_container = container;
        this.addMouseListener(this);
        this.m_pressedThing = -3;
    }

    public void setModel(BudgetModel bm) {
        this.m_model = bm;
    }

    public void setContainer(JComponent comp) {
        this.m_container = comp;
    }

    public void mouseClicked(MouseEvent e) {
        if (e.getY() <= this.m_totalHeight) {
            if (this.m_numVisible == this.m_numTotal) {
                int ind = e.getX() / this.m_maxWidth;
                if (ind < this.m_model.getAccounts().size()) {
                    this.m_model.setCurrentAccount((AccountModel)this.m_model.getAccounts().get(ind));
                }
            } else {
                int ind;
                int x = e.getX();
                if (x <= this.m_arrowWidth) {
                    int i = this.m_model.getAccounts().indexOf(this.m_model.getCurrentAccount());
                    if (i != -1 && i != 0) {
                        this.m_model.setCurrentAccount((AccountModel)this.m_model.getAccounts().get(i - 1));
                    }
                } else if (x > this.m_maxWidth * this.m_numVisible + this.m_arrowWidth && x <= this.m_maxWidth * this.m_numVisible + 2 * this.m_arrowWidth) {
                    int i = this.m_model.getAccounts().indexOf(this.m_model.getCurrentAccount());
                    if (i != -1 && i != this.m_numTotal - 1) {
                        this.m_model.setCurrentAccount((AccountModel)this.m_model.getAccounts().get(i + 1));
                    }
                } else if (x > this.m_arrowWidth && x < this.m_maxWidth * this.m_numVisible + this.m_arrowWidth && (ind = (x - this.m_arrowWidth) / this.m_maxWidth) + this.m_firstVisible < this.m_model.getAccounts().size()) {
                    this.m_model.setCurrentAccount((AccountModel)this.m_model.getAccounts().get(ind + this.m_firstVisible));
                }
            }
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        if (e.getY() <= this.m_totalHeight) {
            if (this.m_numVisible == this.m_numTotal) {
                this.m_pressedThing = e.getX() / this.m_maxWidth;
            } else {
                int x = e.getX();
                if (x <= this.m_arrowWidth) {
                    this.m_pressedThing = -1;
                } else if (x > this.m_maxWidth * this.m_numVisible + this.m_arrowWidth && x <= this.m_maxWidth * this.m_numVisible + 2 * this.m_arrowWidth) {
                    this.m_pressedThing = -2;
                } else if (x > this.m_arrowWidth && x < this.m_maxWidth * this.m_numVisible + this.m_arrowWidth) {
                    this.m_pressedThing = (x - this.m_arrowWidth) / this.m_maxWidth + this.m_firstVisible;
                }
            }
        }
        this.repaint();
    }

    public void mouseReleased(MouseEvent e) {
        this.m_pressedThing = -3;
        this.repaint();
    }

    public void accountListChanged() {
        this.m_numTotal = 0;
        this.m_firstVisible = 0;
        if (this.m_container != null) {
            this.m_container.revalidate();
        }
        this.repaint();
    }

    public void budgetChanged() {
        if (this.m_container != null) {
            this.m_container.revalidate();
        }
        this.repaint();
    }

    public void paintComponent(Graphics g) {
        int totalWidth = 0;
        int height = this.getHeight();
        int width = this.getWidth();
        int ind = 0;
        int maxWidth = 0;
        Font arialFont = new Font("Arial New", 0, 18);
        g.setFont(arialFont);
        FontMetrics fm = g.getFontMetrics();
        this.m_numTotal = this.m_model.getAccounts().size();
        int i = 0;
        while (i < this.m_numTotal) {
            AccountModel am = (AccountModel)this.m_model.getAccounts().get(i);
            totalWidth = fm.stringWidth(am.getName());
            if (totalWidth > maxWidth) {
                maxWidth = totalWidth;
            }
            if (this.m_model.getCurrentAccount() != null && am.equals(this.m_model.getCurrentAccount())) {
                ind = i;
            }
            ++i;
        }
        this.m_maxWidth = maxWidth + 10;
        totalWidth = this.m_maxWidth * this.m_numTotal;
        this.m_arrowWidth = this.m_totalHeight = fm.getHeight() + 10;
        this.m_arrowHeight = this.m_totalHeight;
        this.m_numVisible = this.m_numTotal;
        if (totalWidth > width) {
            this.m_numVisible = (width - 2 * this.m_arrowWidth) / this.m_maxWidth;
            if (this.m_numVisible == 0) {
                this.m_numVisible = this.m_numTotal;
            }
        }
        if (this.m_numVisible == this.m_numTotal) {
            this.m_firstVisible = 0;
        }
        Dimension dim = new Dimension(totalWidth, this.m_totalHeight);
        this.setMinimumSize(new Dimension(this.m_maxWidth + 2 * this.m_arrowWidth, this.m_totalHeight));
        this.setMaximumSize(dim);
        this.setPreferredSize(dim);
        if (this.m_numVisible != this.m_numTotal && (this.m_firstVisible > ind || this.m_firstVisible + this.m_numVisible - 1 < ind)) {
            this.m_firstVisible = ind;
            if (this.m_firstVisible + this.m_numVisible - 1 >= this.m_numTotal) {
                this.m_firstVisible = this.m_numTotal - this.m_numVisible;
            }
        }
        if (this.m_numTotal > this.m_numVisible) {
            int[] xpoints = new int[3];
            int[] ypoints = new int[3];
            if (this.m_firstVisible != 0 || ind != 0) {
                xpoints[0] = 6;
                ypoints[0] = this.m_arrowHeight / 2 + 1;
                xpoints[1] = this.m_arrowWidth - 6 + 1;
                ypoints[1] = 6;
                xpoints[2] = this.m_arrowWidth - 6 + 1;
                ypoints[2] = this.m_arrowHeight - 6 + 1;
                g.setColor(Color.white);
                if (this.m_pressedThing == -1) {
                    g.fillPolygon(xpoints, ypoints, 3);
                }
                g.drawPolygon(xpoints, ypoints, 3);
                xpoints[0] = 5;
                ypoints[0] = this.m_arrowHeight / 2;
                xpoints[1] = this.m_arrowWidth - 6;
                ypoints[1] = 5;
                xpoints[2] = this.m_arrowWidth - 6;
                ypoints[2] = this.m_arrowHeight - 6;
                g.setColor(Color.darkGray);
                g.drawPolygon(xpoints, ypoints, 3);
            } else {
                xpoints[0] = 5;
                ypoints[0] = this.m_arrowHeight / 2;
                xpoints[1] = this.m_arrowWidth - 6;
                ypoints[1] = 5;
                xpoints[2] = this.m_arrowWidth - 6;
                ypoints[2] = this.m_arrowHeight - 6;
                g.setColor(Color.gray);
                g.drawPolygon(xpoints, ypoints, 3);
            }
            if (this.m_firstVisible + this.m_numVisible != this.m_numTotal || ind != this.m_numTotal - 1) {
                xpoints[0] = this.m_arrowWidth + this.m_maxWidth * this.m_numVisible + this.m_arrowWidth - 5 + 1;
                ypoints[0] = this.m_arrowHeight / 2 + 1;
                xpoints[1] = this.m_arrowWidth + this.m_maxWidth * this.m_numVisible + 4 + 1;
                ypoints[1] = 6;
                xpoints[2] = this.m_arrowWidth + this.m_maxWidth * this.m_numVisible + 4 + 1;
                ypoints[2] = this.m_arrowHeight - 6 + 1;
                g.setColor(Color.white);
                if (this.m_pressedThing == -2) {
                    g.fillPolygon(xpoints, ypoints, 3);
                }
                g.drawPolygon(xpoints, ypoints, 3);
                xpoints[0] = this.m_arrowWidth + this.m_maxWidth * this.m_numVisible + this.m_arrowWidth - 5;
                ypoints[0] = this.m_arrowHeight / 2;
                xpoints[1] = this.m_arrowWidth + this.m_maxWidth * this.m_numVisible + 4;
                ypoints[1] = 5;
                xpoints[2] = this.m_arrowWidth + this.m_maxWidth * this.m_numVisible + 4;
                ypoints[2] = this.m_arrowHeight - 6;
                g.setColor(Color.darkGray);
                g.drawPolygon(xpoints, ypoints, 3);
            } else {
                xpoints[0] = this.m_arrowWidth + this.m_maxWidth * this.m_numVisible + this.m_arrowWidth - 5;
                ypoints[0] = this.m_arrowHeight / 2;
                xpoints[1] = this.m_arrowWidth + this.m_maxWidth * this.m_numVisible + 4;
                ypoints[1] = 5;
                xpoints[2] = this.m_arrowWidth + this.m_maxWidth * this.m_numVisible + 4;
                ypoints[2] = this.m_arrowHeight - 6;
                g.setColor(Color.gray);
                g.drawPolygon(xpoints, ypoints, 3);
            }
        }
        i = 0;
        while (i < this.m_numTotal) {
            AccountModel am = (AccountModel)this.m_model.getAccounts().get(i);
            Point textCenter = this.m_numTotal == this.m_numVisible ? new Point((i + 1) * this.m_maxWidth - this.m_maxWidth / 2, this.m_totalHeight / 2 + fm.getAscent() / 2 - fm.getDescent() / 2) : new Point((i - this.m_firstVisible + 1) * this.m_maxWidth - this.m_maxWidth / 2 + this.m_arrowWidth, this.m_totalHeight / 2 + fm.getAscent() / 2 - fm.getDescent() / 2);
            if (i >= this.m_firstVisible && i < this.m_firstVisible + this.m_numVisible) {
                if (this.m_model.getCurrentAccount() != null && am.equals(this.m_model.getCurrentAccount())) {
                    g.setColor(Color.white);
                    g.fillRoundRect(textCenter.x - this.m_maxWidth / 2, 0, this.m_maxWidth - 1, this.m_totalHeight - 1, 10, 10);
                    g.setColor(Color.black);
                    g.drawString(am.getName(), textCenter.x - fm.stringWidth(am.getName()) / 2, textCenter.y);
                    g.setColor(Color.white);
                    g.drawRoundRect(textCenter.x - this.m_maxWidth / 2 + 1, 1, this.m_maxWidth - 2, this.m_totalHeight - 2, 10, 10);
                    g.setColor(Color.darkGray);
                    g.drawRoundRect(textCenter.x - this.m_maxWidth / 2, 0, this.m_maxWidth - 2, this.m_totalHeight - 2, 10, 10);
                } else {
                    g.setColor(Color.white);
                    if (this.m_pressedThing == i) {
                        g.fillRoundRect(textCenter.x - this.m_maxWidth / 2 + 1, 1, this.m_maxWidth - 2, this.m_totalHeight - 2, 10, 10);
                    }
                    g.drawRoundRect(textCenter.x - this.m_maxWidth / 2 + 1, 1, this.m_maxWidth - 2, this.m_totalHeight - 2, 10, 10);
                    g.setColor(Color.darkGray);
                    g.drawRoundRect(textCenter.x - this.m_maxWidth / 2, 0, this.m_maxWidth - 2, this.m_totalHeight - 2, 10, 10);
                    g.setColor(Color.gray);
                    g.drawString(am.getName(), textCenter.x - fm.stringWidth(am.getName()) / 2, textCenter.y);
                }
            }
            ++i;
        }
    }
}

