/*
 * Decompiled with CFR 0.152.
 */
package com.t4d.budget;

import com.t4d.budget.AccountBudgetListListener;
import com.t4d.budget.AccountInfoListener;
import com.t4d.budget.AccountListListener;
import com.t4d.budget.AccountModel;
import com.t4d.budget.BudgetListener;
import com.t4d.budget.BudgetTransactionListener;
import com.t4d.budget.BudgetTransactionModel;
import com.t4d.budget.BudgetTransactionNotFoundException;
import com.t4d.budget.InvalidBudgetTransactionException;
import com.t4d.budget.InvalidDateException;
import com.t4d.budget.JCurrencyField;
import com.t4d.budget.JDateField;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class BudgetTransactionView
extends JPanel
implements BudgetTransactionListener,
AccountBudgetListListener,
AccountListListener,
BudgetListener,
AccountInfoListener,
ActionListener,
FocusListener {
    private BudgetTransactionModel m_model = null;
    private JDateField m_startDateField = new JDateField();
    private JDateField m_endDateField = new JDateField();
    private JTextField m_descField = new JTextField();
    private JCurrencyField m_debField = new JCurrencyField();
    private JCurrencyField m_credField = new JCurrencyField();
    private JComboBox m_transferBox = new JComboBox();
    private JComboBox m_frequencyBox;
    private JButton m_removeBut;
    private String m_lastDesc;
    private String m_lastXfer;
    private int m_dialogsOpen = 0;

    public BudgetTransactionView() {
        String[] frequencies = new String[]{"Only once", "Weekly", "Every two weeks", "Monthly", "Every two months", "Quarterly", "Every six months", "Annually"};
        this.m_frequencyBox = new JComboBox<String>(frequencies);
        this.m_removeBut = new JButton("Delete");
        this.m_startDateField.addActionListener(this);
        this.m_startDateField.setID("startDate");
        this.m_endDateField.addActionListener(this);
        this.m_endDateField.setID("endDate");
        this.m_descField.addActionListener(this);
        this.m_descField.addFocusListener(this);
        this.m_debField.addActionListener(this);
        this.m_debField.setID("Debits");
        this.m_credField.addActionListener(this);
        this.m_credField.setID("Credits");
        this.m_transferBox.addActionListener(this);
        this.m_frequencyBox.addActionListener(this);
        this.m_removeBut.addActionListener(this);
        this.m_startDateField.setHorizontalAlignment(0);
        this.m_endDateField.setHorizontalAlignment(0);
        this.m_descField.setHorizontalAlignment(2);
        this.m_debField.setHorizontalAlignment(4);
        this.m_credField.setHorizontalAlignment(4);
        this.m_transferBox.setFont(new Font("Arial New", 0, 10));
        this.m_frequencyBox.setFont(new Font("Arial New", 0, 10));
        this.m_removeBut.setFont(new Font("Arial New", 0, 10));
        this.add(this.m_startDateField);
        this.add(this.m_endDateField);
        this.add(this.m_descField);
        this.add(this.m_debField);
        this.add(this.m_credField);
        this.add(this.m_transferBox);
        this.add(this.m_frequencyBox);
        this.add(this.m_removeBut);
        this.m_lastDesc = "";
        this.m_lastXfer = "External";
    }

    public BudgetTransactionView(BudgetTransactionModel btm) {
        this();
        this.setModel(btm);
    }

    public void setModel(BudgetTransactionModel btm) {
        if (this.m_model != null) {
            this.m_model.removeBudgetTransactionListener(this);
            if (this.m_model.getAccount() != null) {
                this.m_model.getAccount().removeBudgetListener(this);
                if (this.m_model.getAccount().getBudget() != null) {
                    this.m_model.getAccount().getBudget().removeAccountListListener(this);
                    this.m_model.getAccount().getBudget().removeBudgetListener(this);
                }
            }
        }
        this.m_model = btm;
        if (this.m_model != null) {
            this.m_model.addBudgetTransactionListener(this);
            if (this.m_model.getAccount() != null) {
                this.m_model.getAccount().addBudgetListener(this);
                if (this.m_model.getAccount().getBudget() != null) {
                    this.m_model.getAccount().getBudget().addAccountListListener(this);
                    this.m_model.getAccount().getBudget().addBudgetListener(this);
                }
                if (this.m_model.getCompanion() != null && this.m_model.getCompanion().getAccount() != null) {
                    this.m_lastXfer = this.m_model.getCompanion().getAccount().getName();
                }
            }
        } else {
            this.transferFocus();
        }
        this.redraw();
    }

    public void budgetTransactionInfoChanged() {
        this.redraw();
    }

    public void accountBudgetListChanged() {
        this.redraw();
    }

    public void accountInfoChanged() {
        this.redraw();
    }

    public void accountListChanged() {
        this.redraw();
    }

    public void budgetChanged() {
        this.redraw();
    }

    private void redraw() {
        if (this.m_model == null) {
            this.m_transferBox.removeAllItems();
            this.m_transferBox.addItem("External");
            this.drawSubComponents();
            return;
        }
        this.m_startDateField.setDate(this.m_model.getStartDate());
        this.m_startDateField.setColumns(7);
        this.m_endDateField.setDate(this.m_model.getEndDate());
        this.m_endDateField.setColumns(7);
        this.m_descField.setText(this.m_model.getDescription());
        this.m_descField.setColumns(30);
        if (this.m_model.getAmount() < 0) {
            this.m_debField.setIntValue(-this.m_model.getAmount());
            this.m_credField.setIntValue(0);
        } else {
            this.m_debField.setIntValue(0);
            this.m_credField.setIntValue(this.m_model.getAmount());
        }
        this.m_debField.setColumns(10);
        this.m_credField.setColumns(10);
        if (this.m_model.getAccount() == null) {
            this.m_transferBox.removeAllItems();
            this.m_transferBox.addItem("External");
            this.drawSubComponents();
            return;
        }
        if (this.m_model.getAccount().getBudget() == null) {
            this.m_transferBox.removeAllItems();
            this.m_transferBox.addItem("External");
            this.drawSubComponents();
            return;
        }
        JComboBox<String> xfer = new JComboBox<String>();
        xfer.addItem("External");
        int size = this.m_model.getAccount().getBudget().getAccounts().size();
        int i = 0;
        while (i < size) {
            AccountModel am = (AccountModel)this.m_model.getAccount().getBudget().getAccounts().get(i);
            if (!am.equals(this.m_model.getAccount().getBudget().getCurrentAccount())) {
                xfer.addItem(am.getName());
            }
            ++i;
        }
        size = xfer.getItemCount();
        i = 0;
        while (i < size) {
            if (((String)xfer.getItemAt(i)).equals(this.m_lastXfer)) {
                xfer.setSelectedIndex(i);
                i = size;
            }
            ++i;
        }
        this.m_transferBox = xfer;
        this.m_transferBox.setFont(new Font("Arial New", 0, 10));
        this.m_frequencyBox.setSelectedIndex(this.m_model.getFrequency());
        this.m_lastDesc = this.m_descField.getText();
        this.m_lastXfer = (String)this.m_transferBox.getSelectedItem();
        this.drawSubComponents();
        this.revalidate();
    }

    private void drawSubComponents() {
        this.removeAll();
        this.add(this.m_startDateField);
        this.add(this.m_endDateField);
        this.add(this.m_descField);
        this.add(this.m_debField);
        this.add(this.m_credField);
        this.add(this.m_transferBox);
        this.add(this.m_frequencyBox);
        this.add(this.m_removeBut);
        this.m_transferBox.addActionListener(this);
        this.m_startDateField.repaint();
        this.m_endDateField.repaint();
        this.m_descField.repaint();
        this.m_debField.repaint();
        this.m_credField.repaint();
        this.m_transferBox.repaint();
        this.m_frequencyBox.repaint();
        this.m_removeBut.repaint();
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("Delete")) {
            if (this.m_model != null && this.m_model.getAccount() != null) {
                try {
                    if (this.m_model.getCompanion() != null && this.m_model.getCompanion().getAccount() != null) {
                        this.m_model.getCompanion().getAccount().removeBudgetTransaction(this.m_model.getCompanion());
                    }
                    this.m_model.getAccount().removeBudgetTransaction(this.m_model);
                    this.setModel(null);
                }
                catch (BudgetTransactionNotFoundException btnfe) {}
            }
        } else if (e.getActionCommand().equals("Debits")) {
            if (this.m_model != null) {
                this.m_model.setAmount(-((JCurrencyField)e.getSource()).getIntValue());
            }
        } else if (e.getActionCommand().equals("Credits")) {
            if (this.m_model != null) {
                this.m_model.setAmount(((JCurrencyField)e.getSource()).getIntValue());
            }
        } else if (e.getActionCommand().equals("startDate")) {
            if (this.m_model != null) {
                try {
                    this.m_model.setStartDate(((JDateField)e.getSource()).getDate());
                }
                catch (InvalidDateException ide) {
                    System.out.println(ide);
                    this.redraw();
                }
            }
        } else if (e.getActionCommand().equals("endDate")) {
            if (this.m_model != null) {
                try {
                    this.m_model.setEndDate(((JDateField)e.getSource()).getDate());
                }
                catch (InvalidDateException ide) {
                    System.out.println(ide);
                    if (this.m_dialogsOpen < 1) {
                        ++this.m_dialogsOpen;
                        JOptionPane.showMessageDialog(this, "The ending date must come after the starting date.", "Error!", 0);
                        --this.m_dialogsOpen;
                    }
                    this.redraw();
                }
            }
        } else if (e.getSource().equals(this.m_frequencyBox)) {
            if (this.m_model != null) {
                this.m_model.setFrequency(this.m_frequencyBox.getSelectedIndex());
            }
        } else {
            this.updateFromUI();
        }
    }

    public void focusGained(FocusEvent e) {
    }

    public void focusLost(FocusEvent e) {
        this.updateFromUI();
    }

    private void updateFromUI() {
        String xferStr = (String)this.m_transferBox.getSelectedItem();
        if (!this.m_lastDesc.equals(this.m_descField.getText()) && this.m_model != null) {
            this.m_model.setDescription(this.m_descField.getText());
        }
        if (xferStr != null && !xferStr.equals(this.m_lastXfer)) {
            this.m_lastXfer = xferStr;
            int size = this.m_transferBox.getItemCount();
            int i = 0;
            while (i < size) {
                if (((String)this.m_transferBox.getItemAt(i)).equals(this.m_lastXfer)) {
                    this.m_transferBox.setSelectedIndex(i);
                }
                ++i;
            }
            if (xferStr.equals("External")) {
                if (this.m_model != null && this.m_model.getCompanion() != null && this.m_model.getCompanion().getAccount() != null) {
                    try {
                        this.m_model.getCompanion().getAccount().removeBudgetTransaction(this.m_model.getCompanion());
                    }
                    catch (BudgetTransactionNotFoundException budgetTransactionNotFoundException) {
                        // empty catch block
                    }
                    this.m_model.setCompanion(null);
                }
            } else {
                if (this.m_model != null && this.m_model.getCompanion() != null && this.m_model.getCompanion().getAccount() != null) {
                    try {
                        this.m_model.getCompanion().getAccount().removeBudgetTransaction(this.m_model.getCompanion());
                    }
                    catch (BudgetTransactionNotFoundException budgetTransactionNotFoundException) {
                        // empty catch block
                    }
                    this.m_model.setCompanion(null);
                }
                if (this.m_model != null) {
                    BudgetTransactionModel comp = new BudgetTransactionModel();
                    comp.setDescription(this.m_model.getDescription());
                    comp.setAmount(-this.m_model.getAmount());
                    try {
                        comp.setStartDate(this.m_model.getStartDate());
                    }
                    catch (InvalidDateException invalidDateException) {
                        // empty catch block
                    }
                    try {
                        comp.setEndDate(this.m_model.getEndDate());
                    }
                    catch (InvalidDateException invalidDateException) {
                        // empty catch block
                    }
                    comp.setFrequency(this.m_model.getFrequency());
                    if (this.m_model.getAccount() != null && this.m_model.getAccount().getBudget() != null) {
                        size = this.m_model.getAccount().getBudget().getAccounts().size();
                        i = 0;
                        while (i < size) {
                            AccountModel am = (AccountModel)this.m_model.getAccount().getBudget().getAccounts().get(i);
                            if (am.getName().equals(xferStr)) {
                                try {
                                    am.addBudgetTransaction(comp);
                                    this.m_model.setCompanion(comp);
                                    i = size;
                                }
                                catch (InvalidBudgetTransactionException invalidBudgetTransactionException) {
                                    // empty catch block
                                }
                            }
                            ++i;
                        }
                    }
                }
            }
        }
    }
}

