/*
 * Decompiled with CFR 0.152.
 */
package com.t4d.budget;

import com.t4d.budget.AccountModel;
import com.t4d.budget.BudgetTransactionListener;
import com.t4d.budget.BudgetTransactionNotFoundException;
import com.t4d.budget.InvalidBudgetTransactionException;
import com.t4d.budget.InvalidDateException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Vector;

public class BudgetTransactionModel
implements Serializable {
    public static final int F_ONCE = 0;
    public static final int F_WEEKLY = 1;
    public static final int F_BIWEEKLY = 2;
    public static final int F_MONTHLY = 3;
    public static final int F_BIMONTHLY = 4;
    public static final int F_QUARTERLY = 5;
    public static final int F_SEMIANNUALLY = 6;
    public static final int F_ANNUALLY = 7;
    private Date m_startDate;
    private Date m_endDate;
    private String m_description;
    private int m_depositAmount;
    private int m_frequency;
    private Vector m_listeners = new Vector();
    private AccountModel m_account;
    private BudgetTransactionModel m_companion;

    public BudgetTransactionModel() {
        this.m_startDate = null;
        this.m_endDate = null;
        this.m_description = null;
        this.m_depositAmount = 0;
        this.m_frequency = -1;
        this.m_companion = null;
    }

    public BudgetTransactionModel(Date start, Date end, String desc, int amt, int freq) {
        try {
            this.setStartDate(start);
        }
        catch (InvalidDateException ide) {
            this.m_startDate = new Date();
        }
        try {
            this.setEndDate(end);
        }
        catch (InvalidDateException ide) {
            this.m_endDate = new Date();
        }
        this.m_startDate = start;
        this.m_endDate = end;
        this.m_description = desc;
        this.m_depositAmount = amt;
        this.m_frequency = freq;
        this.m_companion = null;
    }

    public boolean isInitialized() {
        return this.m_startDate != null && this.m_endDate != null && this.m_description != null && this.m_frequency != -1;
    }

    public String getDescription() {
        return this.m_description;
    }

    public void setDescription(String desc) {
        this.m_description = desc;
        if (this.m_companion != null && !this.m_companion.getDescription().equals(this.m_description)) {
            this.m_companion.setDescription(this.m_description);
        }
        this.budgetTransactionInfoChanged();
    }

    public int getFrequency() {
        return this.m_frequency;
    }

    public void setFrequency(int freq) {
        this.m_frequency = freq;
        if (this.m_companion != null && this.m_companion.getFrequency() != this.m_frequency) {
            this.m_companion.setFrequency(this.m_frequency);
        }
        this.budgetTransactionInfoChanged();
    }

    public Date getStartDate() {
        return this.m_startDate;
    }

    public void setStartDate(Date d) throws InvalidDateException {
        if (d == null) {
            InvalidDateException ide = new InvalidDateException("null date is invalid");
            throw ide;
        }
        if (this.m_endDate != null && d.after(this.m_endDate)) {
            GregorianCalendar cal = new GregorianCalendar();
            cal.setTime(this.m_endDate);
            GregorianCalendar calcomp = new GregorianCalendar();
            calcomp.setTime(d);
            if (cal.get(1) - 1900 != calcomp.get(1) - 1900 || cal.get(2) != calcomp.get(2) || cal.get(5) != calcomp.get(5)) {
                this.setEndDate(d);
            }
        }
        if (this.m_account != null) {
            AccountModel account = this.m_account;
            Date oldDate = this.getStartDate();
            try {
                account.removeBudgetTransaction(this);
                this.m_startDate = d;
                account.addBudgetTransaction(this);
                if (this.m_companion != null && this.m_companion.getStartDate() != d) {
                    this.m_companion.setStartDate(d);
                }
                this.budgetTransactionInfoChanged();
            }
            catch (InvalidBudgetTransactionException ibte) {
                System.out.println("There is no reason we should ever get here");
            }
            catch (BudgetTransactionNotFoundException btnfe) {
                this.m_startDate = d;
                if (this.m_companion != null && this.m_companion.getStartDate() != d) {
                    this.m_companion.setStartDate(d);
                }
                this.budgetTransactionInfoChanged();
            }
        } else {
            this.m_startDate = d;
            if (this.m_companion != null && this.m_companion.getStartDate() != d) {
                this.m_companion.setStartDate(d);
            }
            this.budgetTransactionInfoChanged();
        }
    }

    public Date getEndDate() {
        return this.m_endDate;
    }

    public void setEndDate(Date d) throws InvalidDateException {
        if (d == null) {
            InvalidDateException ide = new InvalidDateException("null date is invalid");
            throw ide;
        }
        if (this.m_startDate != null && d.before(this.m_startDate)) {
            GregorianCalendar cal = new GregorianCalendar();
            cal.setTime(this.m_startDate);
            GregorianCalendar calcomp = new GregorianCalendar();
            calcomp.setTime(d);
            if (cal.get(1) - 1900 != calcomp.get(1) - 1900 || cal.get(2) != calcomp.get(2) || cal.get(5) != calcomp.get(5)) {
                InvalidDateException ide = new InvalidDateException("date is in the past, cannot predict past BudgetTransactions.  Use a Transaction");
                throw ide;
            }
        }
        this.m_endDate = d;
        if (this.m_companion != null && this.m_companion.getEndDate() != this.m_endDate) {
            this.m_companion.setEndDate(this.m_endDate);
        }
        this.budgetTransactionInfoChanged();
    }

    public int getAmount() {
        return this.m_depositAmount;
    }

    public void setAmount(int amt) {
        this.m_depositAmount = amt;
        if (this.m_companion != null && this.m_companion.getAmount() != -this.m_depositAmount) {
            this.m_companion.setAmount(-this.m_depositAmount);
        }
        this.budgetTransactionInfoChanged();
    }

    public void addBudgetTransactionListener(BudgetTransactionListener btl) {
        int ind = this.m_listeners.indexOf(btl);
        if (ind == -1) {
            this.m_listeners.add(btl);
        }
    }

    public void removeBudgetTransactionListener(BudgetTransactionListener btl) {
        int ind = this.m_listeners.indexOf(btl);
        if (ind != -1) {
            this.m_listeners.removeElementAt(ind);
        }
    }

    public void budgetTransactionInfoChanged() {
        int size = this.m_listeners.size();
        int i = 0;
        while (i < size) {
            BudgetTransactionListener btl = (BudgetTransactionListener)this.m_listeners.get(i);
            btl.budgetTransactionInfoChanged();
            ++i;
        }
        if (this.m_account != null && this.m_account.getBudget() != null) {
            this.m_account.getBudget().setNeedsSave(true);
        }
    }

    public void setAccount(AccountModel am) {
        if (am != null && !am.isInitialized()) {
            return;
        }
        this.m_account = am;
    }

    public AccountModel getAccount() {
        return this.m_account;
    }

    public void setCompanion(BudgetTransactionModel btm) {
        this.m_companion = btm;
        if (!(this.m_companion == null || this.m_companion.getCompanion() != null && this.m_companion.getCompanion().equals(this))) {
            this.m_companion.setCompanion(this);
        }
    }

    public BudgetTransactionModel getCompanion() {
        return this.m_companion;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        this.m_listeners.removeAllElements();
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
    }

    public String toString() {
        String tmp = this.m_startDate + "-" + this.m_endDate + "," + this.m_description + "," + this.m_depositAmount + ",";
        switch (this.m_frequency) {
            case 0: {
                tmp = String.valueOf(tmp) + "once";
                break;
            }
            case 1: {
                tmp = String.valueOf(tmp) + "weekly";
                break;
            }
            case 2: {
                tmp = String.valueOf(tmp) + "every two weeks";
                break;
            }
            case 3: {
                tmp = String.valueOf(tmp) + "monthly";
                break;
            }
            case 4: {
                tmp = String.valueOf(tmp) + "once every two months";
                break;
            }
            case 5: {
                tmp = String.valueOf(tmp) + "quarterly";
                break;
            }
            case 6: {
                tmp = String.valueOf(tmp) + "every six months";
                break;
            }
            case 7: {
                tmp = String.valueOf(tmp) + "annually";
            }
        }
        return tmp;
    }
}

