/*
 * Decompiled with CFR 0.152.
 */
package com.t4d.budget;

import com.t4d.budget.AccountBudgetListListener;
import com.t4d.budget.AccountInfoListener;
import com.t4d.budget.AccountModel;
import com.t4d.budget.BudgetTransactionModel;
import com.t4d.budget.BudgetTransactionView;
import com.t4d.budget.InvalidBudgetTransactionException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JViewport;

public class BudgetTransactionListView
extends JViewport
implements AccountBudgetListListener,
AccountInfoListener,
ActionListener {
    private AccountModel m_model = null;
    private JPanel m_addPane;
    private JPanel m_list;

    public BudgetTransactionListView() {
        JPanel content = new JPanel();
        content.setLayout(new BorderLayout(0, 0));
        this.m_addPane = new JPanel(new FlowLayout(1, 0, 0));
        JButton addButt = new JButton("Add a new budget transaction");
        addButt.setFont(new Font("Arial New", 0, 10));
        addButt.addActionListener(this);
        this.m_addPane.add(addButt);
        this.m_list = new JPanel();
        this.m_list.setLayout(new GridLayout(0, 1, 0, 0));
        this.m_list.add(this.m_addPane);
        content.add((Component)this.m_list, "North");
        this.add(content);
    }

    public BudgetTransactionListView(AccountModel model) {
        this();
        this.setModel(model);
    }

    public void setModel(AccountModel model) {
        if (this.m_model != null) {
            this.m_model.removeBudgetListener(this);
            this.m_model.removeInfoListener(this);
        }
        this.m_model = model;
        if (this.m_model != null) {
            this.m_model.addBudgetListener(this);
            this.m_model.addInfoListener(this);
        }
        this.redraw();
    }

    public void accountBudgetListChanged() {
        this.redraw();
    }

    public void accountInfoChanged() {
        this.redraw();
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("Add a new budget transaction") && this.m_model != null) {
            try {
                BudgetTransactionModel btm = new BudgetTransactionModel(new Date(), new Date(), "", 0, 0);
                this.m_model.addBudgetTransaction(btm);
            }
            catch (InvalidBudgetTransactionException invalidBudgetTransactionException) {
                // empty catch block
            }
        }
    }

    private void redraw() {
        Component[] complist = this.m_list.getComponents();
        int i = 0;
        while (i < complist.length) {
            if (complist[i] instanceof BudgetTransactionView) {
                ((BudgetTransactionView)complist[i]).setModel(null);
            }
            ++i;
        }
        this.m_list.removeAll();
        if (this.m_model == null) {
            this.revalidate();
            return;
        }
        int size = this.m_model.getBudgetTransactionList().size();
        i = 0;
        while (i < size) {
            BudgetTransactionModel btm = (BudgetTransactionModel)this.m_model.getBudgetTransactionList().get(i);
            BudgetTransactionView btv = new BudgetTransactionView(btm);
            btv.setLayout(new FlowLayout(0, 0, 0));
            this.m_list.add(btv);
            ++i;
        }
        this.m_list.add(this.m_addPane);
        this.revalidate();
    }
}

