/*
 * Decompiled with CFR 0.152.
 */
package com.t4d.budget;

import com.t4d.budget.AccountListListener;
import com.t4d.budget.AccountModel;
import com.t4d.budget.AccountNotFoundException;
import com.t4d.budget.BudgetListener;
import com.t4d.budget.BudgetTransactionModel;
import com.t4d.budget.BudgetTransactionNotFoundException;
import com.t4d.budget.InvalidAccountException;
import com.t4d.budget.InvalidDateException;
import com.t4d.budget.InvalidTransactionException;
import com.t4d.budget.TransactionModel;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Vector;

public class BudgetModel
implements Serializable {
    private Vector m_accountList = new Vector();
    private Vector m_listeners = new Vector();
    private Vector m_budgetListeners = new Vector();
    private AccountModel m_account = null;
    private boolean m_needsSave = true;

    public void addAccount(AccountModel am) throws InvalidAccountException {
        int addHere = -1;
        if (am == null || !am.isInitialized()) {
            InvalidAccountException iae = new InvalidAccountException("Account has not been properly initialized");
            throw iae;
        }
        int i = this.m_accountList.indexOf(am);
        if (i != -1) {
            InvalidAccountException iae = new InvalidAccountException("Duplicate account exists");
            throw iae;
        }
        int size = this.m_accountList.size();
        i = 0;
        while (i < size) {
            AccountModel account = (AccountModel)this.m_accountList.get(i);
            if (addHere == -1 && account.getName().compareToIgnoreCase(am.getName()) > 0) {
                addHere = i;
            }
            ++i;
        }
        if (addHere != -1) {
            this.m_accountList.insertElementAt(am, addHere);
        } else {
            this.m_accountList.add(am);
        }
        am.setBudget(this);
        this.accountListChanged();
    }

    public void removeAccount(AccountModel am) throws AccountNotFoundException {
        if (am == null || !am.isInitialized()) {
            AccountNotFoundException anfe = new AccountNotFoundException("Account has not been properly initialized");
            throw anfe;
        }
        int i = this.m_accountList.indexOf(am);
        if (i == -1) {
            AccountNotFoundException anfe = new AccountNotFoundException("Account was not found in the accountList");
            throw anfe;
        }
        AccountModel account = (AccountModel)this.m_accountList.get(i);
        this.m_accountList.remove(i);
        account.setBudget(null);
        this.accountListChanged();
    }

    public Vector getAccounts() {
        return this.m_accountList;
    }

    public void addAccountListListener(AccountListListener all) {
        int ind = this.m_listeners.indexOf(all);
        if (ind == -1) {
            this.m_listeners.add(all);
        }
    }

    public void removeAccountListListener(AccountListListener all) {
        int ind = this.m_listeners.indexOf(all);
        if (ind != -1) {
            this.m_listeners.removeElementAt(ind);
        }
    }

    private void accountListChanged() {
        if (this.m_account == null) {
            if (this.m_accountList.size() >= 1) {
                this.m_account = (AccountModel)this.m_accountList.get(0);
                this.budgetChanged();
            }
        } else if (this.m_accountList.indexOf(this.m_account) == -1) {
            this.m_account = this.m_accountList.size() >= 1 ? (AccountModel)this.m_accountList.get(0) : null;
            this.budgetChanged();
        }
        int size = this.m_listeners.size();
        int i = 0;
        while (i < size) {
            AccountListListener all = (AccountListListener)this.m_listeners.get(i);
            all.accountListChanged();
            ++i;
        }
        this.setNeedsSave(true);
    }

    public void addBudgetListener(BudgetListener bl) {
        int ind = this.m_budgetListeners.indexOf(bl);
        if (ind == -1) {
            this.m_budgetListeners.add(bl);
        }
    }

    public void removeBudgetListener(BudgetListener bl) {
        int ind = this.m_budgetListeners.indexOf(bl);
        if (ind != -1) {
            this.m_budgetListeners.removeElementAt(ind);
        }
    }

    private void budgetChanged() {
        int i = 0;
        while (i < this.m_budgetListeners.size()) {
            BudgetListener bl = (BudgetListener)this.m_budgetListeners.get(i);
            bl.budgetChanged();
            ++i;
        }
    }

    public AccountModel getCurrentAccount() {
        return this.m_account;
    }

    public void setCurrentAccount(AccountModel am) {
        if (this.m_accountList.indexOf(am) != -1) {
            this.m_account = am;
            this.budgetChanged();
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        this.m_listeners.removeAllElements();
        this.m_budgetListeners.removeAllElements();
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
    }

    public boolean needsSave() {
        return this.m_needsSave;
    }

    public void setNeedsSave(boolean needsSave) {
        this.m_needsSave = needsSave;
    }

    public void convertTransactions(Date end) {
        GregorianCalendar cal = new GregorianCalendar();
        GregorianCalendar calcomp = new GregorianCalendar();
        Date d = null;
        AccountModel account = null;
        BudgetTransactionModel btrans = null;
        Runtime rt = Runtime.getRuntime();
        Vector accounts = this.getAccounts();
        int asize = accounts.size();
        int ai = 0;
        while (ai < asize) {
            account = (AccountModel)accounts.get(ai);
            Vector budgets = account.getBudgetTransactionList();
            Vector tmpBudgets = new Vector();
            boolean addit = true;
            int bsize = budgets.size();
            int bi = 0;
            while (bi < bsize) {
                addit = true;
                btrans = (BudgetTransactionModel)budgets.get(bi);
                if (btrans.getStartDate().after(end)) {
                    cal.setTime(end);
                    calcomp.setTime(btrans.getStartDate());
                    if (cal.get(1) - 1900 != calcomp.get(1) - 1900 || cal.get(2) != calcomp.get(2) || cal.get(5) != calcomp.get(5)) {
                        addit = false;
                    }
                }
                if (addit) {
                    tmpBudgets.add(budgets.get(bi));
                }
                ++bi;
            }
            bsize = tmpBudgets.size();
            bi = 0;
            while (bi < bsize) {
                btrans = (BudgetTransactionModel)tmpBudgets.get(bi);
                boolean isBefore = true;
                while (isBefore) {
                    block58: {
                        block65: {
                            block64: {
                                block63: {
                                    block62: {
                                        block61: {
                                            block60: {
                                                block59: {
                                                    TransactionModel tm = new TransactionModel();
                                                    try {
                                                        tm.setDate(btrans.getStartDate());
                                                    }
                                                    catch (InvalidDateException invalidDateException) {
                                                        // empty catch block
                                                    }
                                                    tm.setAmount(btrans.getAmount());
                                                    tm.setDescription(btrans.getDescription());
                                                    if (btrans.getAccount() != null) {
                                                        try {
                                                            btrans.getAccount().addTransaction(tm);
                                                        }
                                                        catch (InvalidTransactionException invalidTransactionException) {
                                                            // empty catch block
                                                        }
                                                    }
                                                    if (btrans.getCompanion() != null) {
                                                        TransactionModel tm2 = new TransactionModel();
                                                        try {
                                                            tm2.setDate(btrans.getCompanion().getStartDate());
                                                        }
                                                        catch (InvalidDateException invalidDateException) {
                                                            // empty catch block
                                                        }
                                                        tm2.setAmount(btrans.getCompanion().getAmount());
                                                        tm2.setDescription(btrans.getCompanion().getDescription());
                                                        if (btrans.getCompanion().getAccount() != null) {
                                                            try {
                                                                btrans.getCompanion().getAccount().addTransaction(tm2);
                                                            }
                                                            catch (InvalidTransactionException invalidTransactionException) {
                                                                // empty catch block
                                                            }
                                                            tm.setCompanion(tm2);
                                                        }
                                                    }
                                                    if (btrans.getFrequency() != 0) break block59;
                                                    isBefore = false;
                                                    if (btrans.getAccount() != null) {
                                                        try {
                                                            if (btrans.getCompanion() != null && btrans.getCompanion().getAccount() != null) {
                                                                btrans.getCompanion().getAccount().removeBudgetTransaction(btrans.getCompanion());
                                                            }
                                                            btrans.getAccount().removeBudgetTransaction(btrans);
                                                        }
                                                        catch (BudgetTransactionNotFoundException btnfe) {}
                                                    }
                                                    break block58;
                                                }
                                                if (btrans.getFrequency() != 1) break block60;
                                                calcomp.setTime(btrans.getStartDate());
                                                cal.set(1, calcomp.get(1));
                                                cal.set(2, calcomp.get(2));
                                                cal.set(5, calcomp.get(5) + 7);
                                                d = cal.getTime();
                                                try {
                                                    btrans.setStartDate(d);
                                                }
                                                catch (InvalidDateException ide) {
                                                    isBefore = false;
                                                    if (btrans.getAccount() == null) break block58;
                                                    try {
                                                        if (btrans.getCompanion() != null && btrans.getCompanion().getAccount() != null) {
                                                            btrans.getCompanion().getAccount().removeBudgetTransaction(btrans.getCompanion());
                                                        }
                                                        btrans.getAccount().removeBudgetTransaction(btrans);
                                                        break block58;
                                                    }
                                                    catch (BudgetTransactionNotFoundException btnfe) {}
                                                }
                                                break block58;
                                            }
                                            if (btrans.getFrequency() != 2) break block61;
                                            calcomp.setTime(btrans.getStartDate());
                                            cal.set(1, calcomp.get(1));
                                            cal.set(2, calcomp.get(2));
                                            cal.set(5, calcomp.get(5) + 14);
                                            d = cal.getTime();
                                            try {
                                                btrans.setStartDate(d);
                                            }
                                            catch (InvalidDateException ide) {
                                                isBefore = false;
                                                if (btrans.getAccount() == null) break block58;
                                                try {
                                                    if (btrans.getCompanion() != null && btrans.getCompanion().getAccount() != null) {
                                                        btrans.getCompanion().getAccount().removeBudgetTransaction(btrans.getCompanion());
                                                    }
                                                    btrans.getAccount().removeBudgetTransaction(btrans);
                                                    break block58;
                                                }
                                                catch (BudgetTransactionNotFoundException btnfe) {}
                                            }
                                            break block58;
                                        }
                                        if (btrans.getFrequency() != 3) break block62;
                                        calcomp.setTime(btrans.getStartDate());
                                        cal.set(1, calcomp.get(1));
                                        cal.set(2, calcomp.get(2) + 1);
                                        cal.set(5, calcomp.get(5));
                                        d = cal.getTime();
                                        try {
                                            btrans.setStartDate(d);
                                        }
                                        catch (InvalidDateException ide) {
                                            isBefore = false;
                                            if (btrans.getAccount() == null) break block58;
                                            try {
                                                if (btrans.getCompanion() != null && btrans.getCompanion().getAccount() != null) {
                                                    btrans.getCompanion().getAccount().removeBudgetTransaction(btrans.getCompanion());
                                                }
                                                btrans.getAccount().removeBudgetTransaction(btrans);
                                                break block58;
                                            }
                                            catch (BudgetTransactionNotFoundException btnfe) {}
                                        }
                                        break block58;
                                    }
                                    if (btrans.getFrequency() != 4) break block63;
                                    calcomp.setTime(btrans.getStartDate());
                                    cal.set(1, calcomp.get(1));
                                    cal.set(2, calcomp.get(2) + 2);
                                    cal.set(5, calcomp.get(5));
                                    d = cal.getTime();
                                    try {
                                        btrans.setStartDate(d);
                                    }
                                    catch (InvalidDateException ide) {
                                        isBefore = false;
                                        if (btrans.getAccount() == null) break block58;
                                        try {
                                            if (btrans.getCompanion() != null && btrans.getCompanion().getAccount() != null) {
                                                btrans.getCompanion().getAccount().removeBudgetTransaction(btrans.getCompanion());
                                            }
                                            btrans.getAccount().removeBudgetTransaction(btrans);
                                            break block58;
                                        }
                                        catch (BudgetTransactionNotFoundException btnfe) {}
                                    }
                                    break block58;
                                }
                                if (btrans.getFrequency() != 5) break block64;
                                calcomp.setTime(btrans.getStartDate());
                                cal.set(1, calcomp.get(1));
                                cal.set(2, calcomp.get(2) + 3);
                                cal.set(5, calcomp.get(5));
                                d = cal.getTime();
                                try {
                                    btrans.setStartDate(d);
                                }
                                catch (InvalidDateException ide) {
                                    isBefore = false;
                                    if (btrans.getAccount() == null) break block58;
                                    try {
                                        if (btrans.getCompanion() != null && btrans.getCompanion().getAccount() != null) {
                                            btrans.getCompanion().getAccount().removeBudgetTransaction(btrans.getCompanion());
                                        }
                                        btrans.getAccount().removeBudgetTransaction(btrans);
                                        break block58;
                                    }
                                    catch (BudgetTransactionNotFoundException btnfe) {}
                                }
                                break block58;
                            }
                            if (btrans.getFrequency() != 6) break block65;
                            calcomp.setTime(btrans.getStartDate());
                            cal.set(1, calcomp.get(1));
                            cal.set(2, calcomp.get(2) + 6);
                            cal.set(5, calcomp.get(5));
                            d = cal.getTime();
                            try {
                                btrans.setStartDate(d);
                            }
                            catch (InvalidDateException ide) {
                                isBefore = false;
                                if (btrans.getAccount() == null) break block58;
                                try {
                                    if (btrans.getCompanion() != null && btrans.getCompanion().getAccount() != null) {
                                        btrans.getCompanion().getAccount().removeBudgetTransaction(btrans.getCompanion());
                                    }
                                    btrans.getAccount().removeBudgetTransaction(btrans);
                                    break block58;
                                }
                                catch (BudgetTransactionNotFoundException btnfe) {}
                            }
                            break block58;
                        }
                        if (btrans.getFrequency() == 7) {
                            calcomp.setTime(btrans.getStartDate());
                            cal.set(1, calcomp.get(1) + 1);
                            cal.set(2, calcomp.get(2));
                            cal.set(5, calcomp.get(5));
                            d = cal.getTime();
                            try {
                                btrans.setStartDate(d);
                            }
                            catch (InvalidDateException ide) {
                                isBefore = false;
                                if (btrans.getAccount() == null) break block58;
                                try {
                                    if (btrans.getCompanion() != null && btrans.getCompanion().getAccount() != null) {
                                        btrans.getCompanion().getAccount().removeBudgetTransaction(btrans.getCompanion());
                                    }
                                    btrans.getAccount().removeBudgetTransaction(btrans);
                                }
                                catch (BudgetTransactionNotFoundException budgetTransactionNotFoundException) {
                                    // empty catch block
                                }
                            }
                        }
                    }
                    if (!btrans.getStartDate().after(end)) continue;
                    cal.setTime(end);
                    calcomp.setTime(btrans.getStartDate());
                    if (cal.get(1) - 1900 == calcomp.get(1) - 1900 && cal.get(2) == calcomp.get(2) && cal.get(5) == calcomp.get(5)) continue;
                    isBefore = false;
                }
                ++bi;
            }
            ++ai;
        }
        rt.gc();
    }

    public String toString() {
        String tmp = "Accounts included:\n";
        int size = this.m_accountList.size();
        int i = 0;
        while (i < size) {
            AccountModel account = (AccountModel)this.m_accountList.get(i);
            tmp = String.valueOf(tmp) + "\t" + account + "\n";
            ++i;
        }
        return tmp;
    }
}

