/*
 * Decompiled with CFR 0.152.
 */
package com.t4d.budget;

import java.io.File;
import javax.swing.filechooser.FileFilter;

public class BudgetFileFilter
extends FileFilter {
    private String[] m_extensions = null;
    private String m_description = null;

    public BudgetFileFilter() {
    }

    public BudgetFileFilter(String[] extensions) {
        this();
        this.setExtensions(extensions);
    }

    public BudgetFileFilter(String[] extensions, String description) {
        this(extensions);
        this.setDescription(description);
    }

    public void setExtensions(String[] extensions) {
        this.m_extensions = extensions;
    }

    public void setDescription(String description) {
        this.m_description = description;
    }

    public boolean accept(File pathname) {
        if (this.m_extensions == null) {
            return false;
        }
        boolean accepted = false;
        int i = 0;
        while (i < this.m_extensions.length && !accepted) {
            if (pathname.getPath().toUpperCase().endsWith(this.m_extensions[i].toUpperCase())) {
                accepted = true;
            }
            ++i;
        }
        if (pathname.isDirectory()) {
            accepted = true;
        }
        return accepted;
    }

    public String getDescription() {
        String tmp = null;
        tmp = this.m_description == null ? "" : String.valueOf(this.m_description) + " (";
        if (this.m_extensions != null) {
            int i = 0;
            while (i < this.m_extensions.length) {
                if (i > 0) {
                    tmp = String.valueOf(tmp) + ",";
                }
                tmp = String.valueOf(tmp) + "*" + this.m_extensions[i];
                ++i;
            }
        }
        if (this.m_description != null) {
            tmp = String.valueOf(tmp) + ")";
        }
        return tmp;
    }
}

