/*
 * Decompiled with CFR 0.152.
 */
package com.t4d.budget;

import com.t4d.budget.AccountInfoListener;
import com.t4d.budget.BudgetListener;
import com.t4d.budget.BudgetModel;
import com.t4d.budget.BudgetTransactionListView;
import com.t4d.budget.MyButton;
import com.t4d.budget.TransactionListView;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JViewport;

public class AccountView
extends JPanel
implements AccountInfoListener,
BudgetListener,
ActionListener {
    private BudgetModel m_budget = null;
    private JLabel m_accountType;
    private TransactionListView m_tlistPane = new TransactionListView();
    private BudgetTransactionListView m_blistPane = new BudgetTransactionListView();
    private boolean m_viewTransactions;
    private MyButton m_transBut;
    private MyButton m_budgeBut;
    private JViewport m_vhead;
    private JPanel m_transColHead;
    private JPanel m_budgeColHead;
    private JScrollPane m_scroll;

    public AccountView() {
        JPanel headPane = new JPanel();
        FlowLayout fl = new FlowLayout(0);
        headPane.setLayout(fl);
        this.m_accountType = new JLabel();
        this.m_transBut = new MyButton("Transactions");
        this.m_transBut.addActionListener(this);
        this.m_transBut.setPressed(true);
        this.m_transBut.repaint();
        this.m_budgeBut = new MyButton("   Budget   ");
        this.m_budgeBut.addActionListener(this);
        this.m_budgeBut.repaint();
        JPanel footPane = new JPanel(new FlowLayout(1, 0, 0));
        footPane.add(this.m_transBut);
        footPane.add(this.m_budgeBut);
        footPane.revalidate();
        headPane.add(this.m_accountType);
        this.setLayout(new BorderLayout());
        JTextField dateHeader = new JTextField("Date", 7);
        dateHeader.setHorizontalAlignment(0);
        dateHeader.setEditable(false);
        JTextField descHeader = new JTextField("Description", 30);
        descHeader.setHorizontalAlignment(0);
        descHeader.setEditable(false);
        JTextField debHeader = new JTextField("Debits", 10);
        debHeader.setHorizontalAlignment(0);
        debHeader.setEditable(false);
        JTextField credHeader = new JTextField("Credits", 10);
        credHeader.setHorizontalAlignment(0);
        credHeader.setEditable(false);
        JTextField totHeader = new JTextField("Balance", 10);
        totHeader.setHorizontalAlignment(0);
        totHeader.setEditable(false);
        JTextField xferHeader = new JTextField("Transfer to...", 15);
        xferHeader.setHorizontalAlignment(0);
        xferHeader.setEditable(false);
        this.m_transColHead = new JPanel(new FlowLayout(0, 0, 0));
        this.m_transColHead.add(dateHeader);
        this.m_transColHead.add(descHeader);
        this.m_transColHead.add(debHeader);
        this.m_transColHead.add(credHeader);
        this.m_transColHead.add(totHeader);
        this.m_transColHead.add(xferHeader);
        JTextField startDateHeader = new JTextField("Start", 7);
        startDateHeader.setHorizontalAlignment(0);
        startDateHeader.setEditable(false);
        JTextField endDateHeader = new JTextField("Finish", 7);
        endDateHeader.setHorizontalAlignment(0);
        endDateHeader.setEditable(false);
        JTextField bdescHeader = new JTextField("Description", 30);
        bdescHeader.setHorizontalAlignment(0);
        bdescHeader.setEditable(false);
        JTextField bdebHeader = new JTextField("Debits", 10);
        bdebHeader.setHorizontalAlignment(0);
        bdebHeader.setEditable(false);
        JTextField bcredHeader = new JTextField("Credits", 10);
        bcredHeader.setHorizontalAlignment(0);
        bcredHeader.setEditable(false);
        JTextField bxferHeader = new JTextField("Transfer to...", 15);
        bxferHeader.setHorizontalAlignment(0);
        bxferHeader.setEditable(false);
        this.m_budgeColHead = new JPanel(new FlowLayout(0, 0, 0));
        this.m_budgeColHead.add(startDateHeader);
        this.m_budgeColHead.add(endDateHeader);
        this.m_budgeColHead.add(bdescHeader);
        this.m_budgeColHead.add(bdebHeader);
        this.m_budgeColHead.add(bcredHeader);
        this.m_budgeColHead.add(bxferHeader);
        this.m_vhead = new JViewport();
        this.m_vhead.add(this.m_transColHead);
        this.m_scroll = new JScrollPane();
        this.m_scroll.setViewport(this.m_tlistPane);
        this.m_scroll.setColumnHeader(this.m_vhead);
        this.add((Component)headPane, "North");
        this.add((Component)this.m_scroll, "Center");
        this.add((Component)footPane, "South");
        this.m_viewTransactions = true;
        this.revalidate();
    }

    public AccountView(BudgetModel bm) {
        this();
        this.setModel(bm);
    }

    public void setModel(BudgetModel bm) {
        if (this.m_budget != null) {
            this.m_budget.removeBudgetListener(this);
            if (this.m_budget.getCurrentAccount() != null) {
                this.m_budget.getCurrentAccount().removeInfoListener(this);
            }
        }
        this.m_budget = bm;
        if (this.m_budget != null) {
            this.m_budget.addBudgetListener(this);
            if (this.m_budget.getCurrentAccount() != null) {
                this.m_budget.getCurrentAccount().addInfoListener(this);
            }
        }
        this.m_tlistPane.setModel(this.m_budget.getCurrentAccount());
        this.m_blistPane.setModel(this.m_budget.getCurrentAccount());
        this.redraw();
    }

    public void accountInfoChanged() {
        this.redraw();
    }

    public void budgetChanged() {
        this.transferFocus();
        if (this.m_budget != null) {
            this.setModel(this.m_budget);
            this.redraw();
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("Transactions")) {
            this.m_viewTransactions = true;
            this.m_transBut.setPressed(true);
            this.m_budgeBut.setPressed(false);
            this.redraw();
        } else if (e.getActionCommand().equals("   Budget   ")) {
            this.m_viewTransactions = false;
            this.m_transBut.setPressed(false);
            this.m_budgeBut.setPressed(true);
            this.redraw();
        }
    }

    private void redraw() {
        if (this.m_budget.getCurrentAccount() != null) {
            this.m_accountType.setText("Unknown Account Type");
            if (this.m_budget.getCurrentAccount().getType() == 3) {
                this.m_accountType.setText("Credit Card Account");
            } else if (this.m_budget.getCurrentAccount().getType() == 2) {
                this.m_accountType.setText("Savings Account");
            } else if (this.m_budget.getCurrentAccount().getType() == 1) {
                this.m_accountType.setText("Checking Account");
            }
            this.remove(this.m_scroll);
            if (this.m_viewTransactions) {
                this.m_vhead.removeAll();
                this.m_vhead.add(this.m_transColHead);
                this.m_scroll = new JScrollPane();
                this.m_scroll.setViewportView(this.m_tlistPane);
                this.m_scroll.setColumnHeader(this.m_vhead);
            } else {
                this.m_vhead.removeAll();
                this.m_vhead.add(this.m_budgeColHead);
                this.m_scroll = new JScrollPane();
                this.m_scroll.setViewportView(this.m_blistPane);
                this.m_scroll.setColumnHeader(this.m_vhead);
            }
            this.add((Component)this.m_scroll, "Center");
            this.repaint();
        } else {
            this.m_accountType.setText("No accounts available.  Use the button above to add a new account.");
            this.repaint();
        }
    }
}

