/*
 * Decompiled with CFR 0.152.
 */
package com.t4d.budget;

import com.t4d.budget.AccountBudgetListListener;
import com.t4d.budget.AccountInfoListener;
import com.t4d.budget.AccountNotFoundException;
import com.t4d.budget.AccountTransactionListListener;
import com.t4d.budget.BudgetModel;
import com.t4d.budget.BudgetTransactionModel;
import com.t4d.budget.BudgetTransactionNotFoundException;
import com.t4d.budget.InvalidAccountException;
import com.t4d.budget.InvalidBudgetTransactionException;
import com.t4d.budget.InvalidTransactionException;
import com.t4d.budget.TransactionModel;
import com.t4d.budget.TransactionNotFoundException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Vector;

public class AccountModel
implements Serializable {
    public static final int UNSPECIFIED = 0;
    public static final int CHECKING = 1;
    public static final int SAVINGS = 2;
    public static final int CREDIT = 3;
    private String m_accountName;
    private int m_accountType;
    private int m_accountStart;
    private Vector m_transactionList;
    private Vector m_budgetTransactionList;
    private BudgetModel m_budget;
    private Vector m_infoListeners;
    private Vector m_transactionListeners;
    private Vector m_budgetListeners;

    public AccountModel() {
        this.m_accountName = null;
        this.m_accountType = 0;
        this.m_accountStart = 0;
        this.m_transactionList = new Vector();
        this.m_budgetTransactionList = new Vector();
        this.m_budget = null;
        this.m_infoListeners = new Vector();
        this.m_transactionListeners = new Vector();
        this.m_budgetListeners = new Vector();
    }

    public AccountModel(String name, int type, int balance) {
        this.m_accountName = name;
        this.m_accountType = type;
        this.m_accountStart = balance;
        this.m_transactionList = new Vector();
        this.m_budgetTransactionList = new Vector();
        this.m_budget = null;
        this.m_infoListeners = new Vector();
        this.m_transactionListeners = new Vector();
        this.m_budgetListeners = new Vector();
    }

    public AccountModel(String name, int type, int balance, BudgetModel model) {
        this.m_accountName = name;
        this.m_accountType = type;
        this.m_accountStart = balance;
        this.m_transactionList = new Vector();
        this.m_budgetTransactionList = new Vector();
        this.m_budget = model;
        this.m_infoListeners = new Vector();
        this.m_transactionListeners = new Vector();
        this.m_budgetListeners = new Vector();
    }

    public boolean isInitialized() {
        return this.m_accountName != null && this.m_accountType != 0;
    }

    public boolean equals(AccountModel am) {
        return this.m_accountName.equalsIgnoreCase(am.getName());
    }

    public boolean equals(Object o) {
        if (o.getClass().isInstance(this)) {
            return this.equals((AccountModel)o);
        }
        return false;
    }

    public void setName(String name) throws InvalidAccountException {
        if (this.m_budget != null) {
            BudgetModel model = this.m_budget;
            String oldName = this.getName();
            try {
                model.removeAccount(this);
                this.m_accountName = name;
                model.addAccount(this);
                this.accountInfoChanged();
            }
            catch (InvalidAccountException iae) {
                this.m_accountName = oldName;
                model.addAccount(this);
                throw iae;
            }
            catch (AccountNotFoundException anfe) {
                this.m_accountName = name;
                this.accountInfoChanged();
            }
        } else {
            this.m_accountName = name;
            this.accountInfoChanged();
        }
    }

    public String getName() {
        return this.m_accountName;
    }

    public void setStart(int balance) {
        this.m_accountStart = balance;
        this.accountInfoChanged();
    }

    public int getStart() {
        return this.m_accountStart;
    }

    public void setType(int type) {
        if (type == 3 || type == 2 || type == 1) {
            this.m_accountType = type;
            this.accountInfoChanged();
        }
    }

    public int getType() {
        return this.m_accountType;
    }

    public void setBudget(BudgetModel model) {
        this.m_budget = model;
    }

    public BudgetModel getBudget() {
        return this.m_budget;
    }

    public Vector getTransactionList() {
        return this.m_transactionList;
    }

    public Vector getBudgetTransactionList() {
        return this.m_budgetTransactionList;
    }

    public void addInfoListener(AccountInfoListener ail) {
        int ind = this.m_infoListeners.indexOf(ail);
        if (ind == -1) {
            this.m_infoListeners.add(ail);
        }
    }

    public void removeInfoListener(AccountInfoListener ail) {
        int ind = this.m_infoListeners.indexOf(ail);
        if (ind != -1) {
            this.m_infoListeners.removeElementAt(ind);
        }
    }

    public void addTransactionListener(AccountTransactionListListener atll) {
        int ind = this.m_transactionListeners.indexOf(atll);
        if (ind == -1) {
            this.m_transactionListeners.add(atll);
        }
    }

    public void removeTransactionListener(AccountTransactionListListener atll) {
        int ind = this.m_transactionListeners.indexOf(atll);
        if (ind != -1) {
            this.m_transactionListeners.removeElementAt(ind);
        }
    }

    public void addBudgetListener(AccountBudgetListListener abll) {
        int ind = this.m_budgetListeners.indexOf(abll);
        if (ind == -1) {
            this.m_budgetListeners.add(abll);
        }
    }

    public void removeBudgetListener(AccountBudgetListListener abll) {
        int ind = this.m_budgetListeners.indexOf(abll);
        if (ind != -1) {
            this.m_budgetListeners.removeElementAt(ind);
        }
    }

    private void accountInfoChanged() {
        int size = this.m_infoListeners.size();
        int i = 0;
        while (i < size) {
            AccountInfoListener ail = (AccountInfoListener)this.m_infoListeners.get(i);
            ail.accountInfoChanged();
            ++i;
        }
        if (this.m_budget != null) {
            this.m_budget.setNeedsSave(true);
        }
    }

    private void accountTransactionListChanged() {
        int size = this.m_transactionListeners.size();
        int i = 0;
        while (i < size) {
            AccountTransactionListListener atll = (AccountTransactionListListener)this.m_transactionListeners.get(i);
            atll.accountTransactionListChanged();
            ++i;
        }
        if (this.m_budget != null) {
            this.m_budget.setNeedsSave(true);
        }
    }

    private void accountBudgetListChanged() {
        int size = this.m_budgetListeners.size();
        int i = 0;
        while (i < size) {
            AccountBudgetListListener abll = (AccountBudgetListListener)this.m_budgetListeners.get(i);
            abll.accountBudgetListChanged();
            ++i;
        }
        if (this.m_budget != null) {
            this.m_budget.setNeedsSave(true);
        }
    }

    public void addTransaction(TransactionModel trans) throws InvalidTransactionException {
        int addHere = -1;
        if (trans == null || !trans.isInitialized()) {
            InvalidTransactionException ite = new InvalidTransactionException("Transaction has not been properly initialized");
            throw ite;
        }
        int i = this.m_transactionList.indexOf(trans);
        if (i != -1) {
            InvalidTransactionException ite = new InvalidTransactionException("Duplicate transaction already exists");
            throw ite;
        }
        int size = this.m_transactionList.size();
        int min = 0;
        int max = size;
        while (addHere == -1) {
            if (min == max) {
                addHere = min;
                continue;
            }
            TransactionModel transaction = (TransactionModel)this.m_transactionList.get((max + min) / 2);
            if (transaction.getDate().after(trans.getDate())) {
                max = (max + min) / 2;
                continue;
            }
            min = (max + min) / 2 + 1;
        }
        if (addHere != -1) {
            this.m_transactionList.add(addHere, trans);
        } else {
            this.m_transactionList.add(trans);
        }
        trans.setAccount(this);
        this.accountTransactionListChanged();
    }

    public void removeTransaction(TransactionModel trans) throws TransactionNotFoundException {
        if (trans == null || !trans.isInitialized()) {
            TransactionNotFoundException tnfe = new TransactionNotFoundException("Transaction has not been properly initialized");
            throw tnfe;
        }
        int i = this.m_transactionList.indexOf(trans);
        if (i == -1) {
            TransactionNotFoundException tnfe = new TransactionNotFoundException("Transaction was not found in the transactionList");
            throw tnfe;
        }
        this.m_transactionList.remove(i);
        trans.setAccount(null);
        this.accountTransactionListChanged();
    }

    public void addBudgetTransaction(BudgetTransactionModel btrans) throws InvalidBudgetTransactionException {
        int addHere = -1;
        if (btrans == null || !btrans.isInitialized()) {
            InvalidBudgetTransactionException ibte = new InvalidBudgetTransactionException("Budget transaction has not been properly initialized");
            throw ibte;
        }
        int i = this.m_budgetTransactionList.indexOf(btrans);
        if (i != -1) {
            InvalidBudgetTransactionException ibte = new InvalidBudgetTransactionException("Duplicate budget transaction already exists");
            throw ibte;
        }
        int size = this.m_budgetTransactionList.size();
        i = 0;
        while (i < size) {
            BudgetTransactionModel btransaction = (BudgetTransactionModel)this.m_budgetTransactionList.get(i);
            if (addHere == -1 && btransaction.getStartDate().after(btrans.getStartDate())) {
                addHere = i;
            }
            ++i;
        }
        if (addHere != -1) {
            this.m_budgetTransactionList.add(addHere, btrans);
        } else {
            this.m_budgetTransactionList.add(btrans);
        }
        btrans.setAccount(this);
        this.accountBudgetListChanged();
    }

    public void removeBudgetTransaction(BudgetTransactionModel btrans) throws BudgetTransactionNotFoundException {
        if (btrans == null || !btrans.isInitialized()) {
            BudgetTransactionNotFoundException btnfe = new BudgetTransactionNotFoundException("Budget transaction has not been properly initialized");
            throw btnfe;
        }
        int i = this.m_budgetTransactionList.indexOf(btrans);
        if (i == -1) {
            BudgetTransactionNotFoundException btnfe = new BudgetTransactionNotFoundException("Budget transaction was not found in the transactionList");
            throw btnfe;
        }
        this.m_budgetTransactionList.remove(i);
        btrans.setAccount(null);
        this.accountBudgetListChanged();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        this.m_infoListeners.removeAllElements();
        this.m_budgetListeners.removeAllElements();
        this.m_transactionListeners.removeAllElements();
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
    }

    public String toString() {
        String tmp = new String();
        switch (this.m_accountType) {
            case 3: {
                tmp = String.valueOf(tmp) + "CREDIT   ";
                break;
            }
            case 1: {
                tmp = String.valueOf(tmp) + "CHECKING ";
                break;
            }
            case 2: {
                tmp = String.valueOf(tmp) + "SAVINGS  ";
            }
        }
        tmp = String.valueOf(tmp) + this.m_accountStart + " " + this.m_accountName + "\n";
        tmp = String.valueOf(tmp) + "Transactions:\n";
        int size = this.m_transactionList.size();
        int i = 0;
        while (i < size) {
            TransactionModel tm = (TransactionModel)this.m_transactionList.get(i);
            tmp = String.valueOf(tmp) + "\t" + tm + "\n";
            ++i;
        }
        tmp = String.valueOf(tmp) + "Future Transactions:\n";
        size = this.m_budgetTransactionList.size();
        i = 0;
        while (i < size) {
            BudgetTransactionModel btm = (BudgetTransactionModel)this.m_budgetTransactionList.get(i);
            tmp = String.valueOf(tmp) + "\t" + btm + "\n";
            ++i;
        }
        return tmp;
    }
}

