/*
 * Decompiled with CFR 0.152.
 */
package com.t4d.budget;

import com.t4d.budget.AccountNotFoundException;
import com.t4d.budget.BudgetModel;
import com.t4d.budget.NewAccountFrame;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JComponent;
import javax.swing.JOptionPane;

public class AccountMaintenanceView
extends JComponent
implements MouseListener {
    private int m_buttonWidth;
    private int m_buttonHeight;
    private BudgetModel m_budget;
    private Color m_addColor;
    private Color m_delColor;
    private boolean m_firstTime;

    public AccountMaintenanceView() {
        this.addMouseListener(this);
        this.m_budget = null;
        this.m_buttonWidth = 0;
        this.m_addColor = null;
        this.m_delColor = null;
        this.m_firstTime = true;
    }

    public AccountMaintenanceView(BudgetModel bm) {
        this();
        this.setBudget(bm);
    }

    public void setBudget(BudgetModel bm) {
        this.m_budget = bm;
    }

    public void mouseClicked(MouseEvent e) {
        if (e.getY() < this.m_buttonHeight) {
            int del;
            int ind = e.getX() / this.m_buttonWidth;
            if (ind == 0) {
                NewAccountFrame naf = new NewAccountFrame(this.m_budget);
            } else if (this.m_budget != null && this.m_budget.getCurrentAccount() != null && (del = JOptionPane.showConfirmDialog(this, "Permanently delete \"" + this.m_budget.getCurrentAccount().getName() + "\"", "Delete account", 0, 3)) == 0) {
                try {
                    this.m_budget.removeAccount(this.m_budget.getCurrentAccount());
                }
                catch (AccountNotFoundException accountNotFoundException) {
                    // empty catch block
                }
            }
        }
    }

    public void mousePressed(MouseEvent e) {
        if (e.getY() < this.m_buttonHeight) {
            int ind = e.getX() / this.m_buttonWidth;
            if (ind == 0) {
                this.m_addColor = Color.gray;
            } else {
                this.m_delColor = Color.gray;
            }
            this.repaint();
        }
    }

    public void mouseReleased(MouseEvent e) {
        this.m_addColor = null;
        this.m_delColor = null;
        this.repaint();
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void paintComponent(Graphics g) {
        int totalWidth = 0;
        int height = this.getHeight();
        int width = this.getWidth();
        boolean ind = false;
        int maxWidth = 0;
        int totalHeight = 0;
        Font arialFont = new Font("Arial New", 0, 18);
        g.setFont(arialFont);
        FontMetrics fm = g.getFontMetrics();
        maxWidth = fm.stringWidth("Add New Account");
        this.m_buttonWidth = maxWidth += 10;
        totalWidth = maxWidth * 2;
        this.m_buttonHeight = totalHeight = fm.getHeight() + 10;
        Dimension dim = new Dimension(totalWidth, totalHeight);
        this.setMinimumSize(dim);
        this.setMaximumSize(dim);
        this.setPreferredSize(dim);
        int i = 0;
        while (i < 2) {
            Point textCenter = new Point((i + 1) * maxWidth - maxWidth / 2, totalHeight / 2 + fm.getAscent() / 2 - fm.getDescent() / 2);
            if (i == 0) {
                if (this.m_addColor != null) {
                    g.setColor(this.m_addColor);
                    g.fillRoundRect(textCenter.x - maxWidth / 2, 0, maxWidth - 1, totalHeight - 1, 10, 10);
                }
            } else if (this.m_delColor != null) {
                g.setColor(this.m_delColor);
                g.fillRoundRect(textCenter.x - maxWidth / 2, 0, maxWidth - 1, totalHeight - 1, 10, 10);
            }
            g.setColor(Color.white);
            g.drawRoundRect(textCenter.x - maxWidth / 2 + 1, 1, maxWidth - 2, totalHeight - 2, 10, 10);
            g.setColor(Color.darkGray);
            g.drawRoundRect(textCenter.x - maxWidth / 2, 0, maxWidth - 2, totalHeight - 2, 10, 10);
            g.setColor(Color.black);
            if (i == 0) {
                g.drawString("New Account", textCenter.x - fm.stringWidth("New Account") / 2, textCenter.y);
            } else {
                g.drawString("Delete", textCenter.x - fm.stringWidth("Delete") / 2, textCenter.y);
            }
            ++i;
        }
        if (this.m_firstTime) {
            this.revalidate();
            this.m_firstTime = false;
        }
    }
}

