/*
 * Decompiled with CFR 0.152.
 */
import com.t4d.budget.AccountMaintenanceView;
import com.t4d.budget.AccountView;
import com.t4d.budget.BudgetFileFilter;
import com.t4d.budget.BudgetMenuHandler;
import com.t4d.budget.BudgetModel;
import com.t4d.budget.BudgetView;
import com.t4d.budget.BudgetWindowAdapter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class BudgetGuy {
    public BudgetModel m_budgetModel;
    private BudgetView m_bv;
    private AccountView m_av;
    private AccountMaintenanceView m_amv;
    private BudgetWindowAdapter m_bwa;
    private JFrame m_window;

    public static Object showOpenDialog() {
        Object[] possibleValues = new Object[]{"Open Existing Data", "Create New Data"};
        return JOptionPane.showInputDialog(null, "What would you like to do?", "BudgetGuy Startup", -1, null, possibleValues, possibleValues[0]);
    }

    public void initListeners() {
        if (this.m_budgetModel != null) {
            this.m_bv.setModel(this.m_budgetModel);
            this.m_budgetModel.addBudgetListener(this.m_bv);
            this.m_budgetModel.addAccountListListener(this.m_bv);
            this.m_av.setModel(this.m_budgetModel);
            this.m_av.revalidate();
            this.m_bv.repaint();
            this.m_amv.setBudget(this.m_budgetModel);
            this.m_amv.repaint();
        }
    }

    public void quit() {
        WindowEvent e = new WindowEvent(this.m_window, 201);
        this.m_bwa.windowClosing(e);
    }

    public static BudgetModel newModel(BudgetModel bm) {
        if (bm != null) {
            int save = 1;
            boolean saved = false;
            if (bm.needsSave()) {
                save = JOptionPane.showConfirmDialog(null, "Do you want to save your current data", "Save Game", 0, 3);
            }
            if (save == 0) {
                while (!saved) {
                    saved = BudgetGuy.saveModel(bm);
                }
            }
        }
        bm = new BudgetModel();
        bm.setNeedsSave(false);
        return bm;
    }

    public static BudgetModel openModel(BudgetModel bm) {
        if (bm != null) {
            int save = 1;
            boolean saved = false;
            if (bm.needsSave()) {
                save = JOptionPane.showConfirmDialog(null, "Do you want to save your current data", "Save Game", 0, 3);
            }
            if (save == 0) {
                while (!saved) {
                    saved = BudgetGuy.saveModel(bm);
                }
            }
        }
        bm = null;
        JFileChooser chooser = new JFileChooser(System.getProperty("user.dir"));
        String[] extensions = new String[]{".bgd"};
        BudgetFileFilter bff = new BudgetFileFilter(extensions, "BudgetGuy data files");
        chooser.setFileFilter(bff);
        chooser.setMultiSelectionEnabled(false);
        if (chooser.showOpenDialog(null) == 0) {
            File budgetFile = chooser.getSelectedFile();
            try {
                FileInputStream fis = new FileInputStream(budgetFile);
                ObjectInputStream iis = new ObjectInputStream(fis);
                bm = (BudgetModel)iis.readObject();
                bm.setNeedsSave(false);
                iis.close();
            }
            catch (IOException ioe) {
                System.out.println(ioe);
                if (!budgetFile.exists()) {
                    JOptionPane.showMessageDialog(null, "Cannot open file \"" + budgetFile.getPath() + "\".  It appears to not exist", "Error!", 0);
                } else {
                    JOptionPane.showMessageDialog(null, "Cannot open file \"" + budgetFile.getPath() + "\".  It appears to be corrupt", "Error!", 0);
                }
                bm = null;
            }
            catch (ClassNotFoundException cnfe) {
                System.out.println(cnfe);
                JOptionPane.showMessageDialog(null, "File does not contain BudgetGuy data or has been corrupted", "Error!", 0);
                bm = null;
            }
        }
        return bm;
    }

    public static boolean saveModel(BudgetModel bm) {
        boolean saved = false;
        JFileChooser chooser = new JFileChooser(System.getProperty("user.dir"));
        String[] extensions = new String[]{".bgd"};
        BudgetFileFilter bff = new BudgetFileFilter(extensions, "BudgetGuy data files");
        chooser.setFileFilter(bff);
        chooser.setMultiSelectionEnabled(false);
        if (chooser.showSaveDialog(null) == 0) {
            File budgetFile = chooser.getSelectedFile();
            if (!bff.accept(budgetFile)) {
                try {
                    File newBudgetFile;
                    budgetFile = newBudgetFile = new File(String.valueOf(budgetFile.getCanonicalPath()) + ".bgd");
                }
                catch (IOException newBudgetFile) {
                    // empty catch block
                }
            }
            boolean canwrite = false;
            while (!canwrite) {
                if (!budgetFile.exists()) {
                    canwrite = true;
                    continue;
                }
                int result = JOptionPane.showConfirmDialog(null, String.valueOf(budgetFile.getPath()) + " exists.  Overwrite it", "Overwrite", 0, 3);
                if (result == 0) {
                    canwrite = true;
                    continue;
                }
                if (chooser.showSaveDialog(null) != 0 || bff.accept(budgetFile = chooser.getSelectedFile())) continue;
                try {
                    File newBudgetFile;
                    budgetFile = newBudgetFile = new File(String.valueOf(budgetFile.getCanonicalPath()) + ".bgd");
                }
                catch (IOException newBudgetFile) {
                    // empty catch block
                }
            }
            try {
                FileOutputStream fos = new FileOutputStream(budgetFile);
                ObjectOutputStream oos = new ObjectOutputStream(fos);
                oos.writeObject(bm);
                oos.close();
                bm.setNeedsSave(false);
                saved = true;
            }
            catch (IOException ioe) {
                System.out.println(ioe);
                JOptionPane.showMessageDialog(null, "Error saving file", "Error!", 0);
            }
        } else {
            saved = true;
        }
        return saved;
    }

    public static void main(String[] args) {
        Object selectedValue = BudgetGuy.showOpenDialog();
        if (selectedValue == null) {
            System.exit(0);
        }
        BudgetGuy bg = new BudgetGuy();
        bg.m_budgetModel = null;
        if (selectedValue.equals("Create New Data")) {
            bg.m_budgetModel = new BudgetModel();
        } else if (selectedValue.equals("Open Existing Data")) {
            bg.m_budgetModel = BudgetGuy.openModel(null);
            while (bg.m_budgetModel == null) {
                selectedValue = BudgetGuy.showOpenDialog();
                if (selectedValue == null) {
                    return;
                }
                if (selectedValue.equals("Create New Data")) {
                    bg.m_budgetModel = new BudgetModel();
                    continue;
                }
                if (!selectedValue.equals("Open Existing Data")) continue;
                bg.m_budgetModel = BudgetGuy.openModel(null);
            }
        }
        bg.m_budgetModel.setNeedsSave(false);
        bg.m_bv = new BudgetView(bg.m_budgetModel);
        bg.m_budgetModel.addAccountListListener(bg.m_bv);
        bg.m_budgetModel.addBudgetListener(bg.m_bv);
        bg.m_amv = new AccountMaintenanceView(bg.m_budgetModel);
        bg.m_av = new AccountView(bg.m_budgetModel);
        JPanel topPanel = new JPanel(new BorderLayout());
        bg.m_bv.setContainer(topPanel);
        topPanel.add((Component)bg.m_bv, "Center");
        topPanel.add((Component)bg.m_amv, "East");
        bg.m_bv.revalidate();
        bg.m_amv.revalidate();
        topPanel.revalidate();
        JPanel mainPane = new JPanel(new BorderLayout());
        mainPane.add((Component)topPanel, "North");
        mainPane.add((Component)bg.m_av, "Center");
        bg.m_av.revalidate();
        mainPane.revalidate();
        JMenuBar menuBar = new JMenuBar();
        JMenu fileMenu = new JMenu("File");
        JMenu viewMenu = new JMenu("View");
        JMenu actionMenu = new JMenu("Action");
        JMenuItem newFile = new JMenuItem("New");
        JMenuItem loadFile = new JMenuItem("Open");
        JMenuItem saveFile = new JMenuItem("Save");
        JMenuItem exitFile = new JMenuItem("Exit");
        JMenuItem updateAction = new JMenuItem("Convert budgeted transactions");
        JMenuItem graphView = new JMenuItem("View Graph");
        fileMenu.add(newFile);
        fileMenu.addSeparator();
        fileMenu.add(loadFile);
        fileMenu.add(saveFile);
        fileMenu.addSeparator();
        fileMenu.add(exitFile);
        actionMenu.add(updateAction);
        viewMenu.add(graphView);
        BudgetMenuHandler bmh = new BudgetMenuHandler(bg);
        newFile.addActionListener(bmh);
        loadFile.addActionListener(bmh);
        saveFile.addActionListener(bmh);
        exitFile.addActionListener(bmh);
        updateAction.addActionListener(bmh);
        graphView.addActionListener(bmh);
        menuBar.add(fileMenu);
        menuBar.add(viewMenu);
        menuBar.add(actionMenu);
        bg.m_budgetModel.setNeedsSave(false);
        bg.m_bwa = new BudgetWindowAdapter(bg);
        bg.m_window = new JFrame("BudgetGuy");
        bg.m_window.setJMenuBar(menuBar);
        ((Component)bg.m_window).setSize(1100, 500);
        ((Component)bg.m_window).setLocation(100, 100);
        bg.m_window.addWindowListener(bg.m_bwa);
        bg.m_window.getContentPane().add(mainPane);
        bg.m_window.getContentPane().repaint();
        ((Component)bg.m_window).setVisible(true);
    }
}

